/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Module;
import org.eclipse.xtext.junit4.GlobalRegistries;
import org.eclipse.xtext.junit4.IInjectorProvider;
import org.eclipse.xtext.junit4.IRegistryConfigurator;
import org.verapdf.ModelRuntimeModule;
import org.verapdf.ModelStandaloneSetup;

public class ModelInjectorProvider
implements IInjectorProvider,
IRegistryConfigurator {
    protected GlobalRegistries.GlobalStateMemento stateBeforeInjectorCreation;
    protected GlobalRegistries.GlobalStateMemento stateAfterInjectorCreation;
    protected Injector injector;

    static {
        GlobalRegistries.initializeDefaults();
    }

    public Injector getInjector() {
        if (this.injector == null) {
            this.stateBeforeInjectorCreation = GlobalRegistries.makeCopyOfGlobalState();
            this.injector = this.internalCreateInjector();
            this.stateAfterInjectorCreation = GlobalRegistries.makeCopyOfGlobalState();
        }
        return this.injector;
    }

    protected Injector internalCreateInjector() {
        return new ModelStandaloneSetup(){

            public Injector createInjector() {
                return Guice.createInjector((Module[])new Module[]{ModelInjectorProvider.this.createRuntimeModule()});
            }
        }.createInjectorAndDoEMFRegistration();
    }

    protected ModelRuntimeModule createRuntimeModule() {
        return new ModelRuntimeModule(){

            public ClassLoader bindClassLoaderToInstance() {
                return ModelInjectorProvider.class.getClassLoader();
            }
        };
    }

    public void restoreRegistry() {
        this.stateBeforeInjectorCreation.restoreGlobalState();
    }

    public void setupRegistry() {
        this.getInjector();
        this.stateAfterInjectorCreation.restoreGlobalState();
    }
}

