/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
public interface APaperMetaData extends AObject {
	

	public Boolean getcontainsCaption();

	public Boolean getCaptionHasTypeStringText();

	public Boolean getcontainsECC();

	public Boolean getECCHasTypeInteger();

	public Long getECCIntegerValue();

	public Boolean getcontainsHeight();

	public Boolean getHeightHasTypeNumber();

	public Double getHeightNumberValue();

	public Boolean getcontainsResolution();

	public Boolean getResolutionHasTypeNumber();

	public Double getResolutionNumberValue();

	public Boolean getcontainsSymbology();

	public Boolean getSymbologyHasTypeName();

	public String getSymbologyNameValue();

	public Boolean getcontainsType();

	public Boolean getTypeHasTypeName();

	public String getTypeNameValue();

	public Boolean getcontainsVersion();

	public Boolean getVersionHasTypeNumber();

	public Double getVersionNumberValue();

	public Boolean getcontainsWidth();

	public Boolean getWidthHasTypeNumber();

	public Double getWidthNumberValue();

	public Boolean getcontainsXSymWidth();

	public Boolean getXSymWidthHasTypeInteger();

	public Long getXSymWidthIntegerValue();

	public Boolean getcontainsYSymHeight();

	public Boolean getYSymHeightHasTypeInteger();

	public Long getYSymHeightIntegerValue();

	public Boolean getcontainsnCodeWordCol();

	public Boolean getnCodeWordColHasTypeNumber();

	public Boolean getcontainsnCodeWordRow();

	public Boolean getnCodeWordRowHasTypeNumber();
}
