/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.coslayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDDocument;
import org.verapdf.model.salayer.SAPDFDocument;
import org.verapdf.model.pdlayer.PDEncryption;
import org.verapdf.model.external.EmbeddedFile;

		
/**  Information dictionary
 */
public interface CosInfo extends CosDict {
	

	/**  value of ModDate entry
	 */
	public String getModDate();

	/**  string representation of XMP Modify Date
	 */
	public String getXMPModifyDate();

	/**  true, if ModDate entry and XMP Modify Date have equivalent values
	 */
	public Boolean getdoModDatesMatch();

	/**  value of CreationDate entry
	 */
	public String getCreationDate();

	/**  string representation of XMP Create Date
	 */
	public String getXMPCreateDate();

	/**  true, if CreationDate entry and XMP Create Date have equivalent values
	 */
	public Boolean getdoCreationDatesMatch();

	/**  value of Title entry without trailing zero
	 */
	public String getTitle();

	/**  value of XMP Title
	 */
	public String getXMPTitle();

	/**  value of Author entry without trailing zero
	 */
	public String getAuthor();

	/**  comma separated list of XMP Creator array
	 */
	public String getXMPCreator();

	/**  value of Subject entry without trailing zero
	 */
	public String getSubject();

	/**  value of XMP Description
	 */
	public String getXMPDescription();

	/**  value of Producer entry without trailing zero
	 */
	public String getProducer();

	/**  value of XMP Producer
	 */
	public String getXMPProducer();

	/**  value of Creator entry without trailing zero
	 */
	public String getCreator();

	/**  value of XMP Creator Tool
	 */
	public String getXMPCreatorTool();

	/**  value of Keywords entry without trailing zero
	 */
	public String getKeywords();

	/**  value of XMP Keywords
	 */
	public String getXMPKeywords();
}
