/**
 * This file is part of veraPDF Validation Model API, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF Validation Model API is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF Validation Model API as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF Validation Model API as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.model.alayer;
		
import org.verapdf.model.baselayer.Object;

		
/**
*/
public interface AXObjectImageMask extends AObject {
	















	/**
	*/
	public Boolean getcontainsAF();

	/**
	*/
	public String getAFType();

	/**
	*/
	public Boolean getAFHasTypeArray();

	/**
	*/
	public Boolean getAFHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsAlternates();

	/**
	*/
	public String getAlternatesType();

	/**
	*/
	public Boolean getAlternatesHasTypeArray();

	/**
	*/
	public Boolean getcontainsBitsPerComponent();

	/**
	*/
	public String getBitsPerComponentType();

	/**
	*/
	public Boolean getBitsPerComponentHasTypeInteger();

	/**
	*/
	public Long getBitsPerComponentIntegerValue();

	/**
	*/
	public Boolean getcontainsDL();

	/**
	*/
	public String getDLType();

	/**
	*/
	public Boolean getDLHasTypeInteger();

	/**
	*/
	public Long getDLIntegerValue();

	/**
	*/
	public Boolean getcontainsDecode();

	/**
	*/
	public String getDecodeType();

	/**
	*/
	public Boolean getDecodeHasTypeArray();

	/**
	*/
	public Long getDecodeArraySize();

	/**
	*/
	public Boolean getcontainsDecodeParms();

	/**
	*/
	public String getDecodeParmsType();

	/**
	*/
	public Boolean getDecodeParmsHasTypeArray();

	/**
	*/
	public Boolean getDecodeParmsHasTypeDictionary();

	/**
	*/
	public Long getDecodeParmsArraySize();

	/**
	*/
	public Boolean getcontainsF();

	/**
	*/
	public String getFType();

	/**
	*/
	public Boolean getFHasTypeDictionary();

	/**
	*/
	public Boolean getFHasTypeString();

	/**
	*/
	public Boolean getcontainsFDecodeParms();

	/**
	*/
	public String getFDecodeParmsType();

	/**
	*/
	public Boolean getFDecodeParmsHasTypeArray();

	/**
	*/
	public Boolean getFDecodeParmsHasTypeDictionary();

	/**
	*/
	public Long getFDecodeParmsArraySize();

	/**
	*/
	public Boolean getcontainsFFilter();

	/**
	*/
	public String getFFilterType();

	/**
	*/
	public Boolean getFFilterHasTypeArray();

	/**
	*/
	public Boolean getFFilterHasTypeName();

	/**
	*/
	public String getFFilterNameValue();

	/**
	*/
	public Long getFFilterArraySize();

	/**
	*/
	public Boolean getcontainsFilter();

	/**
	*/
	public String getFilterType();

	/**
	*/
	public Boolean getFilterHasTypeArray();

	/**
	*/
	public Boolean getFilterHasTypeName();

	/**
	*/
	public String getFilterNameValue();

	/**
	*/
	public Long getFilterArraySize();

	/**
	*/
	public Boolean getcontainsHeight();

	/**
	*/
	public String getHeightType();

	/**
	*/
	public Boolean getHeightHasTypeInteger();

	/**
	*/
	public Boolean getcontainsID();

	/**
	*/
	public String getentryIDType();

	/**
	*/
	public Boolean getentryIDHasTypeString();

	/**
	*/
	public Boolean getcontainsImageMask();

	/**
	*/
	public String getImageMaskType();

	/**
	*/
	public Boolean getImageMaskHasTypeBoolean();

	/**
	*/
	public Boolean getImageMaskBooleanValue();

	/**
	*/
	public Boolean getcontainsIntent();

	/**
	*/
	public String getIntentType();

	/**
	*/
	public Boolean getIntentHasTypeName();

	/**
	*/
	public Boolean getcontainsInterpolate();

	/**
	*/
	public String getInterpolateType();

	/**
	*/
	public Boolean getInterpolateHasTypeBoolean();

	/**
	*/
	public Boolean getcontainsLength();

	/**
	*/
	public String getLengthType();

	/**
	*/
	public Boolean getLengthHasTypeInteger();

	/**
	*/
	public Boolean getcontainsMeasure();

	/**
	*/
	public String getMeasureType();

	/**
	*/
	public Boolean getMeasureHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsMetadata();

	/**
	*/
	public Boolean getisMetadataIndirect();

	/**
	*/
	public String getMetadataType();

	/**
	*/
	public Boolean getMetadataHasTypeStream();

	/**
	*/
	public Boolean getcontainsName();

	/**
	*/
	public String getNameType();

	/**
	*/
	public Boolean getNameHasTypeName();

	/**
	*/
	public Boolean getcontainsOC();

	/**
	*/
	public String getOCType();

	/**
	*/
	public Boolean getOCHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsOPI();

	/**
	*/
	public String getOPIType();

	/**
	*/
	public Boolean getOPIHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsPtData();

	/**
	*/
	public String getPtDataType();

	/**
	*/
	public Boolean getPtDataHasTypeDictionary();

	/**
	*/
	public Boolean getcontainsSMask();

	/**
	*/
	public Boolean getisSMaskIndirect();

	/**
	*/
	public String getSMaskType();

	/**
	*/
	public Boolean getSMaskHasTypeStream();

	/**
	*/
	public Boolean getcontainsSMaskInData();

	/**
	*/
	public String getSMaskInDataType();

	/**
	*/
	public Boolean getSMaskInDataHasTypeInteger();

	/**
	*/
	public Boolean getcontainsStructParent();

	/**
	*/
	public String getStructParentType();

	/**
	*/
	public Boolean getStructParentHasTypeInteger();

	/**
	*/
	public Boolean getcontainsSubtype();

	/**
	*/
	public String getSubtypeType();

	/**
	*/
	public Boolean getSubtypeHasTypeName();

	/**
	*/
	public String getSubtypeNameValue();

	/**
	*/
	public Boolean getcontainsType();

	/**
	*/
	public String getTypeType();

	/**
	*/
	public Boolean getTypeHasTypeName();

	/**
	*/
	public String getTypeNameValue();

	/**
	*/
	public Boolean getcontainsWidth();

	/**
	*/
	public String getWidthType();

	/**
	*/
	public Boolean getWidthHasTypeInteger();

	/**
	*/
	public Boolean getimageIsStructContentItem();

	/**
	*/
	public Long getDecode0IntegerValue();

	/**
	*/
	public Long getDecode1IntegerValue();

	/**
	*/
	public Boolean gethasExtensionADBE_Extn3();
}
