package org.verapdf.model;

import org.verapdf.model.baselayer.Object;
import java.util.*;

public abstract class GenericModelObject implements Object {
	
	protected Boolean contextDependent = false;
	private final String objectType;
	
	protected GenericModelObject(String objectType) {
		this.objectType = objectType;
	}
	
	/**
	* @return type of the current object
	*/
	public final String getObjectType() {
		return this.objectType;
	}
	
	/**
	* @return id of the current object
	*/
	public String getID() {
		return null;
	}
	
	/**
	* @param link - the name of a link
	* @return List of objects with the given link
	*/
	@Override
	public List<? extends Object> getLinkedObjects(String link) {
        throw new IllegalAccessError(this.getObjectType() + " has not access to this method or has not " + link + " link.");
    }

	/**
	* @return List of names of links for {@code this} object
	*/
    @Override
    public List<String> getLinks() {
        return ModelHelper.getListOfLinks(this.getObjectType());
    }

	/**
	* @return List of names of properties for {@code this} object
	*/
    @Override
    public List<String> getProperties() {
        return ModelHelper.getListOfProperties(this.getObjectType());
    }

	/**
	* @return null, if we have not know yet is this object context dependet of not. true, if this object is context dependent. false, if this object is not context dependent.
	*/
    @Override
    public Boolean isContextDependent() {
        return contextDependent;
    }

	/**
	* @return List of supernames for {@code this} object
	*/
    @Override
    public List<String> getSuperTypes() {
        return ModelHelper.getListOfSuperNames(this.getObjectType());
    }
}
