package org.verapdf.model.coslayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDDocument;
import org.verapdf.model.external.EmbeddedFile;

		
/**  File specification dictionary
 */
public interface CosFileSpecification extends CosDict {
	


	/**  true if the file specification dictionary contains EF key
	 */
	public Boolean getcontainsEF();

	/**  a file specification string (F key)
	 */
	public String getF();

	/**  a unicode file specification (UF key)
	 */
	public String getUF();

	/**  the relationship between the component of the PDF document that refers to this file specification and the associated file (/AFRelationship key)
	 */
	public String getAFRelationship();

	/**  true if the file specification dictionary is associated (=referenced by the /AF key) with at least one of the following objects: catalog, page, XObject, annotation or structure element
	 */
	public Boolean getisAssociatedFile();
}
