package org.verapdf.model.coslayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDDocument;
import org.verapdf.model.external.EmbeddedFile;

		
/**  Low-level PDF Document object 
 */
public interface CosDocument extends CosObject {
	

	/**  number of indirect objects in the document
	 */
	public Long getnrIndirects();

	/**  version of the document
	 */
	public Double getversion();

	/**  true if the OCProperties key is present in the document Catalog
	 */
	public Boolean getisOptionalContentPresent();

	/**  size of data after the EOF and (optional) end of line marker
	 */
	public Long getpostEOFDataSize();

	/**  true if Info dictionary is present and synchronized with the document metadata
	 */
	public Boolean getdoesInfoMatchXMP();

	/**  id of the first page trailer, if the document is linearized. Null, if the document is not linearized
	 */
	public String getfirstPageID();

	/**  id of the last trailer in the document
	 */
	public String getlastID();

	/**  true if the document is linearized
	 */
	public Boolean getisLinearized();





	/**  offset of the PDF document header
	 */
	public Long getheaderOffset();

	/**  the content of the PDF header
	 */
	public String getheader();

	/**  first four bytes in the comment that follows the PDF header
	 */
	public Long getheaderByte1();

	public Long getheaderByte2();

	public Long getheaderByte3();

	public Long getheaderByte4();


	/**  the value of the /Marked entry in the MarkInfo dictionary (false, if this entry is missing)
	 */
	public Boolean getMarked();

	/**  - null, if the /Requirements key is not present in the document Catalog 
	 */
	public String getRequirements();

	/**  NeedsRendering entry in the document's Catalog (false by default)
	 */
	public Boolean getNeedsRendering();

	/**  true, if the document contains the EmbeddedFiles entry in the names dictionary
	 */
	public Boolean getcontainsEmbeddedFiles();
}
