package org.verapdf.model.coslayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDDocument;
import org.verapdf.model.external.EmbeddedFile;

		
/**  PDF Stream type
 */
public interface CosStream extends CosDict {
	

	/**  value of the Length key in the Stream dictionary
	 */
	public Long getLength();

	/**  represents value of F key or null if stream does not contain this key
	 */
	public String getF();

	/**  represents value of FFilter key or null if stream does not contain this key
	 */
	public String getFFilter();

	/**  represents value of FDecodeParms key or null if stream does not contain this key
	 */
	public String getFDecodeParms();

	/**  true if spacings around keywords 'stream' comply to the PDF/A standard
	 */
	public Boolean getstreamKeywordCRLFCompliant();

	/**  true if spacings around keywords 'endstream' comply to the PDF/A standard
	 */
	public Boolean getendstreamKeywordEOLCompliant();

	/**  true if the value of Length key matches the actual length of the stream
	 */
	public Boolean getisLengthCorrect();

}
