package org.verapdf.model.external;
		
import org.verapdf.model.baselayer.Object;
import java.util.List;

		
/**  JPEG2000 image
 */
public interface JPEG2000 extends External {
	

	/**  the number of colour channels
	 */
	public Long getnrColorChannels();

	/**  the number of colour space specifications
	 */
	public Long getnrColorSpaceSpecs();

	/**  the number of colour space specifications with APPROX field set to 0x01
	 */
	public Long getnrColorSpacesWithApproxField();

	/**  the METH entry in the 'colr' box specification with APPROX field equal to 0x01
	 */
	public Long getcolrMethod();

	/**  EnumCS (enumerated color space) field of in the 'colr' box specification with APPROX field equal to 0x01
	 */
	public Long getcolrEnumCS();

	/**  image bit depth
	 */
	public Long getbitDepth();

	/**  true if the 'bpcc' box is present and, thus, the bit depth is not constant across all components
	 */
	public Boolean getbpccBoxPresent();
}
