package org.verapdf.model.pdlayer;
		
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.coslayer.CosDict;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.coslayer.CosReal;
import org.verapdf.model.coslayer.CosNumber;
import org.verapdf.model.coslayer.CosRenderingIntent;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.coslayer.CosIIFilter;
import org.verapdf.model.coslayer.CosBBox;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.external.ICCOutputProfile;
import org.verapdf.model.external.ICCInputProfile;
import org.verapdf.model.external.FontProgram;
import org.verapdf.model.external.CMapFile;
import org.verapdf.model.external.JPEG2000;
import org.verapdf.model.external.PKCSDataObject;
import org.verapdf.model.xmplayer.XMPPackage;

		
/**  One of the simple font types (Type 1, TrueType, Type 3)
 */
public interface PDSimpleFont extends PDFont {
	

	/**  true if the font is one of the 14 standard fonts defined in PDF 1.4 Reference
	 */
	public Boolean getisStandard();

	/**  FirstChar entry; null if LastChar entry is not present or has invalid type
	 */
	public Long getFirstChar();

	/**  LastChar entry; null if LastChar entry is not present or has invalid type
	 */
	public Long getLastChar();

	/**  The size of the Widths array; null if the Widths array is not present or has invalid type
	 */
	public Long getWidths_size();

	/**  - the string "Custom", of the /Encoding entry is a dictionary containing /Differences key
	 */
	public String getEncoding();
}
