/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer;

import java.io.IOException;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Calendar;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.metadata.fixer.entity.InfoDictionary;
import org.verapdf.metadata.fixer.entity.Metadata;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.schemas.AdobePDF;
import org.verapdf.metadata.fixer.schemas.BasicSchema;
import org.verapdf.metadata.fixer.schemas.DublinCore;
import org.verapdf.metadata.fixer.schemas.XMPBasic;
import org.verapdf.metadata.fixer.utils.DateConverter;
import org.verapdf.metadata.fixer.utils.ProcessedObjectsInspector;
import org.verapdf.metadata.fixer.utils.ValidationStatus;
import org.verapdf.metadata.fixer.utils.parser.ProcessedObjectsParser;
import org.verapdf.pdfa.MetadataFixer;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.MetadataFixerResultImpl;
import org.verapdf.pdfa.results.ValidationResult;
import org.verapdf.pdfa.validation.profiles.ProfileDirectory;
import org.verapdf.pdfa.validation.profiles.Profiles;
import org.verapdf.pdfa.validation.profiles.ValidationProfile;
import org.xml.sax.SAXException;

abstract class MetadataFixerImpl
implements MetadataFixer {
    private static final URI componentId = URI.create("http://pdfa.verapdf.org/metadata/fixer#default");
    private static final String componentName = "veraPDF PDF Box Metadata Fixer";
    private static final ComponentDetails componentDetails = Components.libraryDetails((URI)componentId, (String)"veraPDF PDF Box Metadata Fixer");
    private static final ProfileDirectory PROFILES = Profiles.getVeraProfileDirectory();
    private static final Logger LOGGER = Logger.getLogger(MetadataFixerImpl.class);
    private static final Map<String, String> attributes = Collections.unmodifiableMap(MetadataFixerImpl.mkAttsMap());

    protected MetadataFixerImpl() {
    }

    public static MetadataFixerResult fixMetadata(OutputStream output, PDFDocument document, ValidationResult result, boolean fixIdentification, ProcessedObjectsParser parser) {
        return result != null && result.isCompliant() ? new MetadataFixerResultImpl.Builder().build() : MetadataFixerImpl.fixAndSaveDocument(output, document, result, fixIdentification, parser);
    }

    public ComponentDetails getDetails() {
        return componentDetails;
    }

    private static MetadataFixerResult fixAndSaveDocument(OutputStream output, PDFDocument document, ValidationResult result, boolean fixIdentification, ProcessedObjectsParser parser) {
        try {
            Metadata metadata = document.getMetadata();
            if (metadata != null) {
                MetadataFixerResultImpl.Builder resultBuilder = new MetadataFixerResultImpl.Builder();
                ValidationStatus status = MetadataFixerImpl.getValidationStatus(result, parser);
                switch (status) {
                    case INVALID_METADATA: {
                        MetadataFixerImpl.executeInvalidMetadataCase(document, metadata, resultBuilder, result.getPDFAFlavour(), fixIdentification);
                        break;
                    }
                    case INVALID_DOCUMENT: 
                    case INVALID_STRUCTURE: {
                        resultBuilder.status(MetadataFixerResult.RepairStatus.WONT_FIX);
                        if (!fixIdentification) break;
                        metadata.removePDFIdentificationSchema(resultBuilder, result.getPDFAFlavour());
                        break;
                    }
                }
                MetadataFixerImpl.updateModificationDate(document, resultBuilder);
                MetadataFixerResult partialResult = document.saveDocumentIncremental(resultBuilder.getStatus(), output);
                resultBuilder.status(partialResult.getRepairStatus());
                for (String fix : partialResult.getAppliedFixes()) {
                    resultBuilder.addFix(fix);
                }
                return resultBuilder.build();
            }
            return MetadataFixerImpl.getErrorResult("Problems with metadata obtain. No possibility to fix metadata.");
        }
        catch (Exception e) {
            LOGGER.debug((Object)e);
            return MetadataFixerImpl.getErrorResult("Error while fixing metadata: " + e.getMessage());
        }
    }

    private static MetadataFixerResult getErrorResult(String message) {
        MetadataFixerResultImpl.Builder resultBuilder = new MetadataFixerResultImpl.Builder();
        resultBuilder.status(MetadataFixerResult.RepairStatus.FIX_ERROR).addFix(message);
        return resultBuilder.build();
    }

    private static ValidationStatus getValidationStatus(ValidationResult result, ProcessedObjectsParser parser) {
        ValidationProfile profile = PROFILES.getValidationProfileByFlavour(result.getPDFAFlavour());
        if (profile != null) {
            try {
                return ProcessedObjectsInspector.validationStatus((Set)result.getTestAssertions(), (ValidationProfile)profile, (ProcessedObjectsParser)parser);
            }
            catch (IOException | URISyntaxException | ParserConfigurationException | SAXException e) {
                LOGGER.debug((Object)"Problem with validation status obtain. Validation status set as Invalid Document.");
                LOGGER.debug((Object)e);
                return ValidationStatus.INVALID_DOCUMENT;
            }
        }
        LOGGER.debug((Object)"Problem with validation status obtain. Validation status set as Invalid Metadata.");
        return ValidationStatus.INVALID_METADATA;
    }

    private static void executeInvalidMetadataCase(PDFDocument document, Metadata metadata, MetadataFixerResultImpl.Builder resultBuilder, PDFAFlavour flavour, boolean fixIdentification) {
        int removedFilters;
        if (flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1 && (removedFilters = document.removeFiltersForAllMetadataObjects()) > 0) {
            resultBuilder.addFix("Metadata streams unfiltered");
        }
        MetadataFixerImpl.fixMetadata(resultBuilder, document, flavour);
        if (fixIdentification) {
            metadata.addPDFIdentificationSchema(resultBuilder, flavour);
        }
        if (metadata.isNeedToBeUpdated()) {
            metadata.checkMetadataStream(resultBuilder, flavour);
        }
    }

    private static void fixMetadata(MetadataFixerResultImpl.Builder resultBuilder, PDFDocument document, PDFAFlavour flavour) {
        if (flavour.getPart() == PDFAFlavour.Specification.ISO_19005_1) {
            MetadataFixerImpl.fixDublinCoreSchema(resultBuilder, document);
            MetadataFixerImpl.fixAdobePDFSchema(resultBuilder, document);
            MetadataFixerImpl.fixBasicXMLSchema(resultBuilder, document);
        }
    }

    private static void fixDublinCoreSchema(MetadataFixerResultImpl.Builder resultBuilder, PDFDocument document) {
        InfoDictionary info;
        Metadata metadata = document.getMetadata();
        DublinCore schema = metadata.getDublinCoreSchema(info = document.getInfoDictionary());
        if (schema != null && info != null) {
            MetadataFixerImpl.fixProperty(resultBuilder, (BasicSchema)schema, info, schema.getTitle(), info.getTitle(), "title");
            MetadataFixerImpl.fixProperty(resultBuilder, (BasicSchema)schema, info, schema.getSubject(), info.getSubject(), "description");
            MetadataFixerImpl.fixProperty(resultBuilder, (BasicSchema)schema, info, schema.getAuthor(), info.getAuthor(), "creator");
        }
    }

    private static void fixAdobePDFSchema(MetadataFixerResultImpl.Builder resultBuilder, PDFDocument document) {
        InfoDictionary info;
        Metadata metadata = document.getMetadata();
        AdobePDF schema = metadata.getAdobePDFSchema(info = document.getInfoDictionary());
        if (schema != null && info != null) {
            MetadataFixerImpl.fixProperty(resultBuilder, (BasicSchema)schema, info, schema.getProducer(), info.getProducer(), "Producer");
            MetadataFixerImpl.fixProperty(resultBuilder, (BasicSchema)schema, info, schema.getKeywords(), info.getKeywords(), "Keywords");
        }
    }

    private static void fixBasicXMLSchema(MetadataFixerResultImpl.Builder resultBuilder, PDFDocument document) {
        InfoDictionary info;
        Metadata metadata = document.getMetadata();
        XMPBasic schema = metadata.getXMPBasicSchema(info = document.getInfoDictionary());
        if (schema != null && info != null) {
            MetadataFixerImpl.fixProperty(resultBuilder, (BasicSchema)schema, info, schema.getCreator(), info.getCreator(), "CreatorTool");
            MetadataFixerImpl.fixCalendarProperty(resultBuilder, (BasicSchema)schema, info, schema.getCreationDate(), info.getCreationDate(), "CreateDate");
            MetadataFixerImpl.fixCalendarProperty(resultBuilder, (BasicSchema)schema, info, schema.getModificationDate(), info.getModificationDate(), "ModifyDate");
        }
    }

    private static void fixProperty(MetadataFixerResultImpl.Builder resultBuilder, BasicSchema schema, InfoDictionary info, String metaValue, String infoValue, String attribute) {
        if (infoValue != null) {
            String key = attributes.get(attribute);
            if (metaValue == null) {
                MetadataFixerImpl.doSaveAction(schema, attribute, infoValue);
                resultBuilder.addFix("Added '" + key + "' to metadata from info dictionary");
            } else if (!metaValue.equals(infoValue)) {
                MetadataFixerImpl.doSaveAction((BasicSchema)info, attribute, metaValue);
                resultBuilder.addFix("Added '" + attribute + "' to info dictionary from metadata");
            }
        }
    }

    private static void fixCalendarProperty(MetadataFixerResultImpl.Builder resultBuilder, BasicSchema schema, InfoDictionary info, String metaValue, String infoValue, String attribute) {
        if (infoValue != null) {
            String key = attributes.get(attribute);
            String utcInfoValue = DateConverter.toUTCString(infoValue);
            if (metaValue == null) {
                MetadataFixerImpl.doSaveAction(schema, attribute, infoValue);
                resultBuilder.addFix("Added '" + key + "' to metadata from info dictionary");
            } else if (!metaValue.equals(utcInfoValue) || !infoValue.matches("(D:)?(\\d\\d){2,7}((([+-](\\d\\d[']))(\\d\\d['])?)?|[Z])")) {
                MetadataFixerImpl.doSaveAction((BasicSchema)info, attribute, metaValue);
                resultBuilder.addFix("Added '" + attribute + "' to info dictionary from metadata");
            }
        }
    }

    private static void doSaveAction(BasicSchema schema, String attribute, String value) {
        switch (attribute) {
            case "title": {
                ((DublinCore)schema).setTitle(value);
                break;
            }
            case "description": {
                ((DublinCore)schema).setSubject(value);
                break;
            }
            case "creator": {
                ((DublinCore)schema).setAuthor(value);
                break;
            }
            case "Producer": {
                ((AdobePDF)schema).setProducer(value);
                break;
            }
            case "Keywords": {
                ((AdobePDF)schema).setKeywords(value);
                break;
            }
            case "CreatorTool": {
                ((XMPBasic)schema).setCreator(value);
                break;
            }
            case "CreateDate": {
                ((XMPBasic)schema).setCreationDate(value);
                break;
            }
            case "ModifyDate": {
                ((XMPBasic)schema).setModificationDate(value);
                break;
            }
            default: {
                return;
            }
        }
        schema.setNeedToBeUpdated(true);
    }

    private static void updateModificationDate(PDFDocument document, MetadataFixerResultImpl.Builder resultBuilder) {
        InfoDictionary info = document.getInfoDictionary();
        XMPBasic schema = document.getMetadata().getXMPBasicSchema(info);
        if (document.isNeedToBeUpdated() && schema != null) {
            Calendar time = Calendar.getInstance(TimeZone.getTimeZone("UTC"));
            if (schema.getModificationDate() != null) {
                MetadataFixerImpl.doSaveAction((BasicSchema)schema, "ModifyDate", DateConverter.toUTCString(time));
                resultBuilder.addFix("Set new modification date to metadata");
            }
            if (info != null && info.getModificationDate() != null) {
                MetadataFixerImpl.doSaveAction((BasicSchema)info, "ModifyDate", DateConverter.toPDFFormat(time));
                resultBuilder.addFix("Set new modification date to info dictionary");
            }
        }
    }

    private static final Map<String, String> mkAttsMap() {
        HashMap<String, String> atts = new HashMap<String, String>();
        atts.put("title", "Title");
        atts.put("description", "Subject");
        atts.put("creator", "Author");
        atts.put("Producer", "Producer");
        atts.put("Keywords", "Keywords");
        atts.put("CreatorTool", "Creator");
        atts.put("CreateDate", "CreationDate");
        atts.put("ModifyDate", "ModDate");
        return atts;
    }
}

