/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.impl.pb.model;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.VeraPDFMeta;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObject;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.verapdf.metadata.fixer.entity.InfoDictionary;
import org.verapdf.metadata.fixer.entity.Metadata;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.impl.pb.model.InfoDictionaryImpl;
import org.verapdf.metadata.fixer.impl.pb.model.MetadataImpl;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.MetadataFixerResultImpl;

public class PDFDocumentImpl
implements PDFDocument {
    private static final Logger LOGGER = Logger.getLogger(PDFDocumentImpl.class);
    private final PDDocument document;
    private MetadataImpl metadata;
    private InfoDictionaryImpl info;
    private boolean isUnfiltered = false;

    public PDFDocumentImpl(InputStream pdfStream) throws IOException {
        this(PDDocument.load((InputStream)pdfStream, (boolean)false, (boolean)true));
    }

    public PDFDocumentImpl(PDDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("Document representation can not be null");
        }
        this.document = document;
        this.metadata = this.parseMetadata();
        this.info = this.getInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetadataImpl parseMetadata() {
        PDDocumentCatalog catalog = this.document.getDocumentCatalog();
        PDMetadata meta = catalog.getMetadata();
        if (meta != null) return PDFDocumentImpl.parseMetadata(meta);
        try (COSStream stream = this.document.getDocument().createCOSStream();){
            catalog.setMetadata(new PDMetadata(stream));
            catalog.getCOSObject().setNeedToBeUpdated(true);
            VeraPDFMeta xmp = VeraPDFMeta.create();
            MetadataImpl metadataImpl = new MetadataImpl(xmp, stream);
            return metadataImpl;
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
        return PDFDocumentImpl.parseMetadata(meta);
    }

    private static MetadataImpl parseMetadata(PDMetadata meta) {
        try {
            VeraPDFMeta xmp = VeraPDFMeta.parse((InputStream)meta.getStream().getUnfilteredStream());
            if (xmp != null) {
                return new MetadataImpl(xmp, meta.getStream());
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)("Problems with document parsing or structure. " + e.getMessage()), (Throwable)e);
        }
        catch (XMPException e) {
            LOGGER.debug((Object)("Problems with XMP parsing. " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private InfoDictionaryImpl getInfo() {
        COSDictionary trailer = this.document.getDocument().getTrailer();
        COSBase infoDict = trailer.getDictionaryObject(COSName.INFO);
        return !(infoDict instanceof COSDictionary) ? null : new InfoDictionaryImpl(new PDDocumentInformation((COSDictionary)infoDict));
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public InfoDictionary getInfoDictionary() {
        return this.info;
    }

    public boolean isNeedToBeUpdated() {
        boolean metaUpd = this.metadata != null && this.metadata.isNeedToBeUpdated();
        boolean infoUpd = this.info != null && this.info.isNeedToBeUpdated();
        return metaUpd || infoUpd || this.isUnfiltered;
    }

    public MetadataFixerResult saveDocumentIncremental(MetadataFixerResult.RepairStatus status, OutputStream output) {
        MetadataFixerResultImpl.Builder builder = new MetadataFixerResultImpl.Builder();
        try {
            boolean isMetaAdd;
            PDMetadata meta = this.document.getDocumentCatalog().getMetadata();
            boolean isMetaPresent = meta != null && this.isNeedToBeUpdated();
            boolean bl = isMetaAdd = meta == null && this.metadata != null;
            if (isMetaPresent || isMetaAdd) {
                this.metadata.updateMetadataStream();
                if (isMetaAdd) {
                    this.document.getDocumentCatalog().getCOSObject().setNeedToBeUpdated(true);
                }
                this.document.saveIncremental(output);
                output.close();
                builder.status(PDFDocumentImpl.getStatus(status));
            } else {
                builder.status(status);
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)e);
            builder.status(MetadataFixerResult.RepairStatus.FIX_ERROR).addFix("Problems with document save. " + e.getMessage());
        }
        return builder.build();
    }

    public int removeFiltersForAllMetadataObjects() {
        int res = 0;
        try {
            List objects = this.document.getDocument().getObjectsByType(COSName.METADATA);
            ArrayList<COSStream> metas = new ArrayList<COSStream>();
            for (COSObject obj : objects) {
                COSBase base = obj.getObject();
                if (base instanceof COSStream) {
                    metas.add((COSStream)base);
                    continue;
                }
                LOGGER.debug((Object)"Founded non-stream Metadata dictionary.");
            }
            for (COSStream stream : metas) {
                COSBase filters = stream.getFilters();
                if (!(filters instanceof COSName) && (!(filters instanceof COSArray) || ((COSArray)filters).size() == 0)) continue;
                try {
                    stream.setFilters(null);
                    stream.setNeedToBeUpdated(true);
                    ++res;
                }
                catch (IOException e) {
                    LOGGER.debug((Object)"Problems with unfilter stream.", (Throwable)e);
                }
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)"Can not obtain Metadata objects", (Throwable)e);
        }
        this.isUnfiltered = res > 0;
        return res;
    }

    private static MetadataFixerResult.RepairStatus getStatus(MetadataFixerResult.RepairStatus status) {
        return status == MetadataFixerResult.RepairStatus.NO_ACTION ? MetadataFixerResult.RepairStatus.SUCCESS : status;
    }
}

