/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.metadata.fixer.impl.pb.model;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.VeraPDFMeta;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.verapdf.metadata.fixer.entity.InfoDictionary;
import org.verapdf.metadata.fixer.entity.Metadata;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.impl.pb.model.InfoDictionaryImpl;
import org.verapdf.metadata.fixer.impl.pb.model.MetadataImpl;
import org.verapdf.pdfa.results.MetadataFixerResult;
import org.verapdf.pdfa.results.MetadataFixerResultImpl;

public class PDFDocumentImpl
implements PDFDocument {
    private static final Logger LOGGER = Logger.getLogger(PDFDocumentImpl.class);
    private final PDDocument document;
    private MetadataImpl metadata;
    private InfoDictionaryImpl info;
    private boolean isUnfiltered = false;

    public PDFDocumentImpl(InputStream pdfStream) throws IOException {
        this(PDDocument.load((InputStream)pdfStream, (boolean)false, (boolean)true));
    }

    public PDFDocumentImpl(PDDocument document) {
        if (document == null) {
            throw new IllegalArgumentException("Document representation can not be null");
        }
        this.document = document;
        this.metadata = this.parseMetadata();
        this.info = this.getInfo();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private MetadataImpl parseMetadata() {
        PDDocumentCatalog catalog = this.document.getDocumentCatalog();
        PDMetadata meta = catalog.getMetadata();
        if (meta != null) return PDFDocumentImpl.parseMetadata(meta);
        try (COSStream stream = this.document.getDocument().createCOSStream();){
            catalog.setMetadata(new PDMetadata(stream));
            catalog.getCOSObject().setNeedToBeUpdated(true);
            VeraPDFMeta xmp = VeraPDFMeta.create();
            MetadataImpl metadataImpl = new MetadataImpl(xmp, stream);
            return metadataImpl;
        }
        catch (IOException excep) {
            excep.printStackTrace();
        }
        return PDFDocumentImpl.parseMetadata(meta);
    }

    private static MetadataImpl parseMetadata(PDMetadata meta) {
        try {
            VeraPDFMeta xmp = VeraPDFMeta.parse((InputStream)meta.getStream().getUnfilteredStream());
            if (xmp != null) {
                return new MetadataImpl(xmp, meta.getStream());
            }
        }
        catch (IOException e) {
            LOGGER.debug((Object)("Problems with document parsing or structure. " + e.getMessage()), (Throwable)e);
        }
        catch (XMPException e) {
            LOGGER.debug((Object)("Problems with XMP parsing. " + e.getMessage()), (Throwable)e);
        }
        return null;
    }

    private InfoDictionaryImpl getInfo() {
        COSDictionary trailer = this.document.getDocument().getTrailer();
        COSBase infoDict = trailer.getDictionaryObject(COSName.INFO);
        return !(infoDict instanceof COSDictionary) ? null : new InfoDictionaryImpl(new PDDocumentInformation((COSDictionary)infoDict));
    }

    public Metadata getMetadata() {
        return this.metadata;
    }

    public InfoDictionary getInfoDictionary() {
        return this.info;
    }

    public boolean isNeedToBeUpdated() {
        boolean metaUpd = this.metadata != null && this.metadata.isNeedToBeUpdated();
        boolean infoUpd = this.info != null && this.info.isNeedToBeUpdated();
        return metaUpd || infoUpd || this.isUnfiltered;
    }

    public MetadataFixerResult saveDocumentIncremental(MetadataFixerResult.RepairStatus status, OutputStream output) {
        MetadataFixerResultImpl.Builder builder = new MetadataFixerResultImpl.Builder();
        try {
            boolean isMetaAdd;
            PDMetadata meta = this.document.getDocumentCatalog().getMetadata();
            boolean isMetaPresent = meta != null && this.isNeedToBeUpdated();
            boolean bl = isMetaAdd = meta == null && this.metadata != null;
            if (isMetaPresent || isMetaAdd) {
                this.metadata.updateMetadataStream();
                if (isMetaAdd) {
                    this.document.getDocumentCatalog().getCOSObject().setNeedToBeUpdated(true);
                }
                this.document.saveIncremental(output);
                output.close();
                builder.status(PDFDocumentImpl.getStatus(status));
            } else {
                builder.status(status);
            }
        }
        catch (Exception e) {
            LOGGER.info((Object)e);
            builder.status(MetadataFixerResult.RepairStatus.FIX_ERROR).addFix("Problems with document save. " + e.getMessage());
        }
        return builder.build();
    }

    /*
     * Exception decompiling
     */
    public int removeFiltersForAllMetadataObjects() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static MetadataFixerResult.RepairStatus getStatus(MetadataFixerResult.RepairStatus status) {
        return status == MetadataFixerResult.RepairStatus.NO_ACTION ? MetadataFixerResult.RepairStatus.SUCCESS : status;
    }
}

