/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.functions.PBoxPDFunction;
import org.verapdf.model.pdlayer.PDHalftone;

public class PBoxPDHalftone
extends PBoxPDObject
implements PDHalftone {
    public static final String HALFTONE_TYPE = "PDHalftone";
    private static final String HALFTONES = "halftones";
    private static final String CUSTOM_FUNCTION = "customFunction";
    private final String halftoneName;
    private final Long halftoneType;
    private final String colorantName;

    public PBoxPDHalftone(COSDictionary dict) {
        this(dict, null);
    }

    public PBoxPDHalftone(COSDictionary dict, String colorantName) {
        super((COSObjectable)dict, HALFTONE_TYPE);
        this.halftoneName = PBoxPDHalftone.getHalftoneName(dict);
        this.halftoneType = PBoxPDHalftone.getHalftoneType(dict);
        this.colorantName = colorantName;
    }

    public PBoxPDHalftone(COSName name) {
        super((COSObjectable)name, HALFTONE_TYPE);
        boolean isDefault = COSName.getPDFName((String)"Default").equals((java.lang.Object)name);
        this.halftoneName = isDefault ? null : name.getName();
        this.halftoneType = isDefault ? Long.valueOf(1L) : null;
        this.colorantName = null;
    }

    private static Long getHalftoneType(COSDictionary dict) {
        COSBase type = dict.getDictionaryObject(COSName.getPDFName((String)"HalftoneType"));
        return !(type instanceof COSNumber) ? null : Long.valueOf(((COSNumber)type).longValue());
    }

    private static String getHalftoneName(COSDictionary dict) {
        COSBase name = dict.getDictionaryObject(COSName.getPDFName((String)"HalftoneName"));
        if (name instanceof COSName) {
            return ((COSName)name).getName();
        }
        if (name instanceof COSString) {
            return ((COSString)name).getString();
        }
        if (name != null) {
            return name.toString();
        }
        return null;
    }

    public Long getHalftoneType() {
        return this.halftoneType;
    }

    public String getHalftoneName() {
        return this.halftoneName;
    }

    public String getcolorantName() {
        return this.colorantName;
    }

    public String getTransferFunction() {
        if (this.simplePDObject instanceof COSDictionary) {
            COSBase base = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.getPDFName((String)"TransferFunction"));
            return base == null ? null : (base instanceof COSName ? ((COSName)base).getName() : base.toString());
        }
        return null;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "halftones": {
                return this.getHalftones();
            }
            case "customFunction": {
                return this.getCustomFunction();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDHalftone> getHalftones() {
        if (this.halftoneType == null || this.halftoneType != 5L) {
            return Collections.emptyList();
        }
        ArrayList<PBoxPDHalftone> halftones = new ArrayList<PBoxPDHalftone>();
        if (this.simplePDObject instanceof COSDictionary) {
            COSDictionary object = (COSDictionary)this.simplePDObject;
            for (COSName key : object.keySet()) {
                COSBase value = object.getDictionaryObject(key);
                if (!(value instanceof COSDictionary)) continue;
                PBoxPDHalftone halftone = new PBoxPDHalftone((COSDictionary)value, key.getName());
                halftones.add(halftone);
            }
        }
        return Collections.unmodifiableList(halftones);
    }

    private List<PBoxPDFunction> getCustomFunction() {
        return Collections.emptyList();
    }
}

