/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd.actions;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionNamed;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionRemoteGoTo;
import org.apache.pdfbox.pdmodel.interactive.action.PDActionRendition;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.actions.PBoxPDGoToAction;
import org.verapdf.model.impl.pb.pd.actions.PBoxPDGoToRemoteAction;
import org.verapdf.model.impl.pb.pd.actions.PBoxPDNamedAction;
import org.verapdf.model.impl.pb.pd.actions.PBoxPDRenditionAction;
import org.verapdf.model.pdlayer.PDAction;

public class PBoxPDAction
extends PBoxPDObject
implements PDAction {
    public static final String ACTION_TYPE = "PDAction";
    public static final String NEXT = "Next";

    public PBoxPDAction(org.apache.pdfbox.pdmodel.interactive.action.PDAction simplePDObject) {
        this(simplePDObject, ACTION_TYPE);
    }

    public PBoxPDAction(org.apache.pdfbox.pdmodel.interactive.action.PDAction simplePDObject, String type) {
        super((COSObjectable)simplePDObject, type);
    }

    public String getS() {
        return ((org.apache.pdfbox.pdmodel.interactive.action.PDAction)this.simplePDObject).getSubType();
    }

    public List<? extends Object> getLinkedObjects(String link) {
        if (NEXT.equals(link)) {
            return this.getNext();
        }
        return super.getLinkedObjects(link);
    }

    private List<PDAction> getNext() {
        List nextActionList = ((org.apache.pdfbox.pdmodel.interactive.action.PDAction)this.simplePDObject).getNext();
        if (nextActionList != null) {
            ArrayList<PDAction> actions = new ArrayList<PDAction>(nextActionList.size());
            for (org.apache.pdfbox.pdmodel.interactive.action.PDAction action : nextActionList) {
                PDAction result = PBoxPDAction.getAction(action);
                if (result == null) continue;
                actions.add(result);
            }
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    public static PDAction getAction(org.apache.pdfbox.pdmodel.interactive.action.PDAction action) {
        if (action == null) {
            return null;
        }
        switch (action.getSubType()) {
            case "Named": {
                return new PBoxPDNamedAction((PDActionNamed)action);
            }
            case "GoTo": {
                return new PBoxPDGoToAction((PDActionGoTo)action);
            }
            case "GoToR": {
                return new PBoxPDGoToRemoteAction((PDActionRemoteGoTo)action);
            }
            case "Rendition": {
                return new PBoxPDRenditionAction((PDActionRendition)action);
            }
        }
        return new PBoxPDAction(action);
    }
}

