/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model;

import com.adobe.xmp.XMPException;
import com.adobe.xmp.impl.VeraPDFMeta;
import java.io.Closeable;
import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.cos.PBCosDocument;
import org.verapdf.pdfa.ValidationModelParser;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public final class ModelParser
implements ValidationModelParser,
Closeable {
    private static final Logger LOGGER = Logger.getLogger(ModelParser.class);
    private static final PDFAFlavour DEFAULT_FLAVOUR = PDFAFlavour.PDFA_1_B;
    private PDDocument document;
    private final PDFAFlavour flavour;

    private ModelParser(PDDocument document, PDFAFlavour flavour) throws IOException {
        this.document = document;
        this.flavour = flavour;
    }

    public static ModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour) throws IOException {
        PDDocument document = PDDocument.load((InputStream)toLoad, (boolean)false, (boolean)true);
        PDFAFlavour resultFlavour = flavour == PDFAFlavour.AUTO ? ModelParser.obtainFlavour(document) : (flavour == PDFAFlavour.NO_FLAVOUR || flavour == null ? DEFAULT_FLAVOUR : flavour);
        return new ModelParser(document, resultFlavour);
    }

    private static PDFAFlavour obtainFlavour(PDDocument document) {
        if (document == null) {
            return DEFAULT_FLAVOUR;
        }
        PDDocumentCatalog documentCatalog = document.getDocumentCatalog();
        if (documentCatalog == null) {
            return DEFAULT_FLAVOUR;
        }
        PDMetadata metadata = documentCatalog.getMetadata();
        if (metadata == null) {
            return DEFAULT_FLAVOUR;
        }
        try {
            InputStream is = metadata.exportXMPMetadata();
            VeraPDFMeta veraPDFMeta = VeraPDFMeta.parse((InputStream)is);
            Integer identificationPart = veraPDFMeta.getIdentificationPart();
            String identificationConformance = veraPDFMeta.getIdentificationConformance();
            PDFAFlavour pdfaFlavour = PDFAFlavour.byFlavourId((String)(identificationPart + identificationConformance));
            return pdfaFlavour == PDFAFlavour.NO_FLAVOUR ? DEFAULT_FLAVOUR : pdfaFlavour;
        }
        catch (XMPException | IOException e) {
            LOGGER.error((java.lang.Object)e);
            return DEFAULT_FLAVOUR;
        }
    }

    public PDDocument getPDDocument() throws IOException {
        return this.document;
    }

    public Object getRoot() throws IOException {
        return new PBCosDocument(this.document, this.flavour);
    }

    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    @Override
    public void close() {
        try {
            if (this.document != null) {
                this.document.close();
            }
        }
        catch (IOException e) {
            LOGGER.error((java.lang.Object)"Problems with document close.", (Throwable)e);
        }
    }
}

