/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.verapdf.model.coslayer.CosObject;
import org.verapdf.model.impl.pb.cos.PBCosArray;
import org.verapdf.model.impl.pb.cos.PBCosObject;
import org.verapdf.model.impl.pb.cos.PBCosStream;
import org.verapdf.model.impl.pb.pd.PBoxPDFormField;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDFormField;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDAcroForm
extends PBoxPDObject
implements PDAcroForm {
    public static final String ACRO_FORM_TYPE = "PDAcroForm";
    public static final String FORM_FIELDS = "formFields";
    public static final String XFA = "XFA";
    private final boolean needAppearance;
    private final PDDocument document;
    private final PDFAFlavour flavour;

    public PBoxPDAcroForm(org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm acroForm, PDDocument document, PDFAFlavour flavour) {
        super((COSObjectable)acroForm, ACRO_FORM_TYPE);
        this.needAppearance = acroForm.getNeedAppearances();
        this.document = document;
        this.flavour = flavour;
    }

    public Boolean getNeedAppearances() {
        return this.needAppearance;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "formFields": {
                return this.getFormFields();
            }
            case "XFA": {
                return this.getXFA();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDFormField> getFormFields() {
        List fields = ((org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm)this.simplePDObject).getFields();
        ArrayList<PBoxPDFormField> formFields = new ArrayList<PBoxPDFormField>(1);
        for (PDField field : fields) {
            formFields.add(new PBoxPDFormField(field));
        }
        return Collections.unmodifiableList(formFields);
    }

    private List<CosObject> getXFA() {
        COSBase value;
        boolean isStream;
        org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm form = (org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm)this.simplePDObject;
        if (form.hasXFA() && ((isStream = (value = form.getCOSObject().getDictionaryObject(COSName.XFA)) instanceof COSStream) || value instanceof COSArray)) {
            ArrayList<PBCosObject> list = new ArrayList<PBCosObject>(1);
            if (isStream) {
                list.add(new PBCosStream((COSStream)value, this.document, this.flavour));
            } else {
                list.add(new PBCosArray((COSArray)value, this.document, this.flavour));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

