/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDPageTree;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDDestinationOrAction;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.graphics.color.PDOutputIntent;
import org.apache.pdfbox.pdmodel.graphics.optionalcontent.PDOptionalContentProperties;
import org.apache.pdfbox.pdmodel.interactive.action.PDAction;
import org.apache.pdfbox.pdmodel.interactive.action.PDDocumentCatalogAdditionalActions;
import org.verapdf.model.impl.pb.pd.PBoxPDAcroForm;
import org.verapdf.model.impl.pb.pd.PBoxPDMetadata;
import org.verapdf.model.impl.pb.pd.PBoxPDOCProperties;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.impl.pb.pd.PBoxPDOutputIntent;
import org.verapdf.model.impl.pb.pd.PBoxPDPage;
import org.verapdf.model.impl.pb.pd.PBoxPDStructTreeRoot;
import org.verapdf.model.pdlayer.PDAcroForm;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.pdlayer.PDOCProperties;
import org.verapdf.model.pdlayer.PDOutline;
import org.verapdf.model.pdlayer.PDPage;
import org.verapdf.model.pdlayer.PDStructTreeRoot;
import org.verapdf.model.tools.OutlinesHelper;
import org.verapdf.pdfa.flavours.PDFAFlavour;

public class PBoxPDDocument
extends PBoxPDObject
implements org.verapdf.model.pdlayer.PDDocument {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDDocument.class);
    public static final String PD_DOCUMENT_TYPE = "PDDocument";
    public static final String PAGES = "pages";
    public static final String METADATA = "metadata";
    public static final String OUTPUT_INTENTS = "outputIntents";
    public static final String ACRO_FORMS = "AcroForm";
    public static final String ACTIONS = "AA";
    public static final String OPEN_ACTION = "OpenAction";
    public static final String OUTLINES = "Outlines";
    public static final String STRUCTURE_TREE_ROOT = "StructTreeRoot";
    public static final String ALTERNATE_PRESENTATIONS = "AlternatePresentations";
    public static final String OC_PROPERTIES = "OCProperties";
    public static final int MAX_NUMBER_OF_ACTIONS = 5;
    private final PDDocumentCatalog catalog = this.getDocumentCatalog();
    private final PDFAFlavour flavour;

    public PBoxPDDocument(PDDocument document, PDFAFlavour flavour) {
        super(document, PD_DOCUMENT_TYPE);
        this.flavour = flavour;
    }

    private PDDocumentCatalog getDocumentCatalog() {
        try {
            COSDictionary object = (COSDictionary)this.document.getDocument().getCatalog().getObject();
            return new PDDocumentCatalog(this.document, object);
        }
        catch (IOException e) {
            LOGGER.warn((Object)"Catalog cannot be found.");
            LOGGER.debug((Object)e);
            return null;
        }
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "Outlines": {
                return this.getOutlines();
            }
            case "OpenAction": {
                return this.getOpenAction();
            }
            case "AA": {
                return this.getActions();
            }
            case "pages": {
                return this.getPages();
            }
            case "metadata": {
                return this.getMetadata();
            }
            case "outputIntents": {
                return this.getOutputIntents();
            }
            case "AcroForm": {
                return this.getAcroForms();
            }
            case "StructTreeRoot": {
                return this.getStructureTreeRoot();
            }
            case "OCProperties": {
                return this.getOCProperties();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDOutline> getOutlines() {
        return OutlinesHelper.getOutlines(this.catalog);
    }

    private List<org.verapdf.model.pdlayer.PDAction> getOpenAction() {
        if (this.catalog != null) {
            try {
                PDDestinationOrAction openAction = this.catalog.getOpenAction();
                if (openAction instanceof PDAction) {
                    ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(1);
                    this.addAction(actions, (PDAction)openAction);
                    return Collections.unmodifiableList(actions);
                }
            }
            catch (IOException e) {
                LOGGER.error((Object)("Problems with open action obtaining. " + e.getMessage()), (Throwable)e);
            }
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDAction> getActions() {
        PDDocumentCatalogAdditionalActions pbActions = this.getAdditionalAction();
        if (pbActions != null) {
            ArrayList<org.verapdf.model.pdlayer.PDAction> actions = new ArrayList<org.verapdf.model.pdlayer.PDAction>(5);
            PDAction buffer = pbActions.getDP();
            this.addAction(actions, buffer);
            buffer = pbActions.getDS();
            this.addAction(actions, buffer);
            buffer = pbActions.getWP();
            this.addAction(actions, buffer);
            buffer = pbActions.getWS();
            this.addAction(actions, buffer);
            buffer = pbActions.getWC();
            this.addAction(actions, buffer);
            return Collections.unmodifiableList(actions);
        }
        return Collections.emptyList();
    }

    private PDDocumentCatalogAdditionalActions getAdditionalAction() {
        COSDictionary catalogLocal;
        COSBase aaDictionary;
        if (this.catalog != null && (aaDictionary = (catalogLocal = this.catalog.getCOSObject()).getDictionaryObject(COSName.AA)) instanceof COSDictionary) {
            return new PDDocumentCatalogAdditionalActions((COSDictionary)aaDictionary);
        }
        return null;
    }

    private List<PDPage> getPages() {
        PDPageTree pageTree = this.document.getPages();
        ArrayList<PBoxPDPage> pages = new ArrayList<PBoxPDPage>(pageTree.getCount());
        for (org.apache.pdfbox.pdmodel.PDPage page : pageTree) {
            pages.add(new PBoxPDPage(page, this.document, this.flavour));
        }
        return Collections.unmodifiableList(pages);
    }

    private List<PDMetadata> getMetadata() {
        org.apache.pdfbox.pdmodel.common.PDMetadata meta;
        if (this.catalog != null && (meta = this.catalog.getMetadata()) != null && meta.getCOSObject() != null) {
            ArrayList<PBoxPDMetadata> metadata = new ArrayList<PBoxPDMetadata>(1);
            metadata.add(new PBoxPDMetadata(meta, Boolean.TRUE, this.document, this.flavour));
            return Collections.unmodifiableList(metadata);
        }
        return Collections.emptyList();
    }

    private List<org.verapdf.model.pdlayer.PDOutputIntent> getOutputIntents() {
        if (this.catalog != null) {
            List pdfboxOutputIntents = this.catalog.getOutputIntents();
            ArrayList<PBoxPDOutputIntent> outputIntents = new ArrayList<PBoxPDOutputIntent>(pdfboxOutputIntents.size());
            for (PDOutputIntent intent : pdfboxOutputIntents) {
                outputIntents.add(new PBoxPDOutputIntent(intent, this.document, this.flavour));
            }
            return Collections.unmodifiableList(outputIntents);
        }
        return Collections.emptyList();
    }

    private List<PDAcroForm> getAcroForms() {
        org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm form;
        if (this.catalog != null && (form = this.catalog.getAcroForm()) != null) {
            ArrayList<PBoxPDAcroForm> forms = new ArrayList<PBoxPDAcroForm>(1);
            forms.add(new PBoxPDAcroForm(form, this.document, this.flavour));
            return Collections.unmodifiableList(forms);
        }
        return Collections.emptyList();
    }

    private List<PDStructTreeRoot> getStructureTreeRoot() {
        PDStructureTreeRoot root;
        if (this.catalog != null && (root = this.catalog.getStructureTreeRoot()) != null) {
            ArrayList<PBoxPDStructTreeRoot> treeRoot = new ArrayList<PBoxPDStructTreeRoot>(1);
            treeRoot.add(new PBoxPDStructTreeRoot(root));
            return Collections.unmodifiableList(treeRoot);
        }
        return Collections.emptyList();
    }

    public Boolean getcontainsAlternatePresentations() {
        COSBase alternatePresentations;
        COSDictionary rawCatalog;
        COSDictionary namesDictionary;
        if (this.catalog != null && (namesDictionary = (COSDictionary)(rawCatalog = this.catalog.getCOSObject()).getDictionaryObject(COSName.NAMES)) != null && (alternatePresentations = namesDictionary.getDictionaryObject(COSName.getPDFName((String)ALTERNATE_PRESENTATIONS))) != null) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private List<PDOCProperties> getOCProperties() {
        PDOptionalContentProperties pBoxOCProperties = this.catalog.getOCProperties();
        if (pBoxOCProperties != null) {
            ArrayList<PDOCProperties> result = new ArrayList<PDOCProperties>();
            PBoxPDOCProperties ocProperties = new PBoxPDOCProperties((COSObjectable)pBoxOCProperties);
            result.add(ocProperties);
            return result;
        }
        return Collections.emptyList();
    }
}

