/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.impl.pb.cos.PBCosUnicodeName;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDStructElem;
import org.verapdf.model.tools.TaggedPDFHelper;

public class PBoxPDStructElem
extends PBoxPDObject
implements PDStructElem {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDStructElem.class);
    public static final String STRUCTURE_ELEMENT_TYPE = "PDStructElem";
    public static final String CHILDREN = "K";
    public static final String STRUCTURE_TYPE = "S";

    public PBoxPDStructElem(COSDictionary structElemDictionary) {
        super((COSObjectable)structElemDictionary, STRUCTURE_ELEMENT_TYPE);
    }

    public String getType() {
        COSBase value = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.TYPE);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        LOGGER.warn((java.lang.Object)("In struct element type expected 'COSName' but got: " + value.getClass().getSimpleName()));
        return null;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
            case "S": {
                return this.getStructureType();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<PDStructElem> getChildren() {
        return TaggedPDFHelper.getChildren((COSDictionary)this.simplePDObject, LOGGER);
    }

    private List<CosUnicodeName> getStructureType() {
        COSBase type = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.S);
        if (type instanceof COSName) {
            ArrayList<PBCosUnicodeName> list = new ArrayList<PBCosUnicodeName>(1);
            list.add(new PBCosUnicodeName((COSName)type));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }
}

