/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.io.InputStream;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.metadata.fixer.impl.fixer.PBoxMetadataFixerImpl;
import org.verapdf.model.ModelParser;
import org.verapdf.pdfa.MetadataFixer;
import org.verapdf.pdfa.PDFParser;
import org.verapdf.pdfa.VeraPDFFoundry;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.pdfa.validators.ReferenceBatchValidator;
import org.verapdf.processor.ProcessorImpl;

public class PdfBoxFoundry
implements VeraPDFFoundry {
    private static PdfBoxFoundry INSTANCE = new PdfBoxFoundry();

    private PdfBoxFoundry() {
    }

    public static void initialise() {
        ProcessorImpl.initialise((VeraPDFFoundry)INSTANCE);
        ReferenceBatchValidator.initialise((VeraPDFFoundry)INSTANCE);
    }

    public PDFParser newPdfParser(InputStream pdfStream) throws ModelParsingException, EncryptedPdfException {
        return this.newPdfParser(pdfStream, PDFAFlavour.AUTO);
    }

    public PDFParser newPdfParser(InputStream pdfStream, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return ModelParser.createModelWithFlavour(pdfStream, flavour);
    }

    public MetadataFixer newMetadataFixer() {
        return new PBoxMetadataFixerImpl();
    }
}

