/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.containers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.verapdf.model.impl.pb.pd.colors.PBoxPDSeparation;

public class StaticContainers {
    private static ThreadLocal<Map<String, List<PBoxPDSeparation>>> separations = new ThreadLocal();
    private static ThreadLocal<List<String>> inconsistentSeparations = new ThreadLocal();
    private static ThreadLocal<Map<PDColorSpace, org.verapdf.model.pdlayer.PDColorSpace>> cachedColorSpaces = new ThreadLocal();
    private static ThreadLocal<Set<COSObjectKey>> fileSpecificationKeys = new ThreadLocal();

    public static void clearAllContainers() {
        StaticContainers.getSeparations().clear();
        StaticContainers.getInconsistentSeparations().clear();
        StaticContainers.getCachedColorSpaces().clear();
        StaticContainers.getFileSpecificationKeys().clear();
    }

    public static Map<String, List<PBoxPDSeparation>> getSeparations() {
        StaticContainers.checkForNull(separations, new HashMap());
        return separations.get();
    }

    public static void setSeparations(Map<String, List<PBoxPDSeparation>> separations) {
        StaticContainers.separations.set(separations);
    }

    public static List<String> getInconsistentSeparations() {
        StaticContainers.checkForNull(inconsistentSeparations, new ArrayList());
        return inconsistentSeparations.get();
    }

    public static void setInconsistentSeparations(List<String> inconsistentSeparations) {
        StaticContainers.inconsistentSeparations.set(inconsistentSeparations);
    }

    public static Map<PDColorSpace, org.verapdf.model.pdlayer.PDColorSpace> getCachedColorSpaces() {
        StaticContainers.checkForNull(cachedColorSpaces, new HashMap());
        return cachedColorSpaces.get();
    }

    public static void setCachedColorSpaces(Map<PDColorSpace, org.verapdf.model.pdlayer.PDColorSpace> cachedColorSpaces) {
        StaticContainers.cachedColorSpaces.set(cachedColorSpaces);
    }

    public static Set<COSObjectKey> getFileSpecificationKeys() {
        StaticContainers.checkForNull(fileSpecificationKeys, new HashSet());
        return fileSpecificationKeys.get();
    }

    public static void setFileSpecificationKeys(Set<COSObjectKey> fileSpecificationKeys) {
        StaticContainers.fileSpecificationKeys.set(fileSpecificationKeys);
    }

    private static void checkForNull(ThreadLocal variable, Object object) {
        if (variable.get() == null) {
            variable.set(object);
        }
    }
}

