/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.log4j.Logger;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.verapdf.model.coslayer.CosStream;
import org.verapdf.model.impl.axl.AXLMainXMPPackage;
import org.verapdf.model.impl.axl.AXLXMPPackage;
import org.verapdf.model.impl.pb.cos.PBCosStream;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDMetadata;
import org.verapdf.model.xmplayer.XMPPackage;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.impl.VeraPDFMeta;
import org.verapdf.xmp.impl.VeraPDFXMPNode;

public class PBoxPDMetadata
extends PBoxPDObject
implements PDMetadata {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDMetadata.class);
    public static final String METADATA_TYPE = "PDMetadata";
    public static final String XMP_PACKAGE = "XMPPackage";
    public static final String STREAM = "stream";
    private boolean isMainMetadata;
    private org.apache.pdfbox.pdmodel.common.PDMetadata mainMetadata;
    private PDFAFlavour flavour;

    public PBoxPDMetadata(org.apache.pdfbox.pdmodel.common.PDMetadata simplePDObject, Boolean isMainMetadata, PDDocument document, PDFAFlavour flavour) {
        super((COSObjectable)simplePDObject, METADATA_TYPE);
        this.isMainMetadata = isMainMetadata;
        this.mainMetadata = document != null && document.getDocumentCatalog() != null && document.getDocumentCatalog().getMetadata() != null ? document.getDocumentCatalog().getMetadata() : null;
        this.flavour = flavour;
    }

    public String getFilter() {
        List filters = ((org.apache.pdfbox.pdmodel.common.PDMetadata)this.simplePDObject).getFilters();
        if (filters != null && !filters.isEmpty()) {
            StringBuilder result = new StringBuilder();
            for (COSName filter : filters) {
                result.append(filter.getName()).append(' ');
            }
            return result.substring(0, result.length() - 1);
        }
        return null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "XMPPackage": {
                return this.getXMPPackage();
            }
            case "stream": {
                return this.getStream();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<XMPPackage> getXMPPackage() {
        ArrayList<XMPPackage> xmp;
        block8: {
            xmp = new ArrayList<XMPPackage>(1);
            try {
                COSStream stream = ((org.apache.pdfbox.pdmodel.common.PDMetadata)this.simplePDObject).getStream();
                if (stream != null) {
                    VeraPDFMeta metadata = VeraPDFMeta.parse((InputStream)stream.getUnfilteredStream());
                    if (this.isMainMetadata) {
                        xmp.add((XMPPackage)new AXLMainXMPPackage(metadata, true, this.flavour));
                    } else if (this.flavour == null || this.flavour.getPart() == null || this.flavour.getPart().getPartNumber() != 1) {
                        COSStream mainStream = this.mainMetadata.getStream();
                        VeraPDFXMPNode mainExtensionNode = null;
                        if (mainStream != null) {
                            VeraPDFMeta mainMeta = VeraPDFMeta.parse((InputStream)mainStream.getUnfilteredStream());
                            mainExtensionNode = mainMeta.getExtensionSchemasNode();
                        }
                        xmp.add((XMPPackage)new AXLXMPPackage(metadata, true, mainExtensionNode, this.flavour));
                    }
                }
            }
            catch (IOException | XMPException e) {
                LOGGER.debug((Object)("Problems with parsing metadata. " + e.getMessage()), e);
                if (this.isMainMetadata) {
                    xmp.add((XMPPackage)new AXLMainXMPPackage(null, false, this.flavour));
                }
                if (this.flavour != null && this.flavour.getPart() != null && this.flavour.getPart().getPartNumber() == 1) break block8;
                xmp.add((XMPPackage)new AXLXMPPackage(null, false, null, this.flavour));
            }
        }
        return xmp;
    }

    private List<CosStream> getStream() {
        COSStream stream = ((org.apache.pdfbox.pdmodel.common.PDMetadata)this.simplePDObject).getStream();
        if (stream != null) {
            ArrayList<PBCosStream> streams = new ArrayList<PBCosStream>(1);
            streams.add(new PBCosStream(stream, this.document, this.flavour));
            return Collections.unmodifiableList(streams);
        }
        return Collections.emptyList();
    }

    public static boolean isMetadataObject(COSBase obj) {
        return obj instanceof COSStream && ((COSStream)obj).getCOSName(COSName.TYPE) == COSName.METADATA && ((COSStream)obj).getCOSName(COSName.SUBTYPE) == COSName.getPDFName((String)"XML");
    }
}

