/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.encryption.InvalidPasswordException;
import org.verapdf.ReleaseDetails;
import org.verapdf.component.ComponentDetails;
import org.verapdf.component.Components;
import org.verapdf.core.EncryptedPdfException;
import org.verapdf.core.ModelParsingException;
import org.verapdf.features.AbstractFeaturesExtractor;
import org.verapdf.features.FeatureExtractionResult;
import org.verapdf.features.FeatureExtractorConfig;
import org.verapdf.features.pb.PBFeatureParser;
import org.verapdf.metadata.fixer.entity.PDFDocument;
import org.verapdf.metadata.fixer.impl.pb.model.PDFDocumentImpl;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.impl.pb.containers.StaticContainers;
import org.verapdf.model.impl.pb.cos.PBCosDocument;
import org.verapdf.pdfa.Foundries;
import org.verapdf.pdfa.PDFAParser;
import org.verapdf.pdfa.flavours.PDFAFlavour;
import org.verapdf.xmp.XMPException;
import org.verapdf.xmp.containers.StaticXmpCoreContainers;
import org.verapdf.xmp.impl.VeraPDFMeta;

public final class ModelParser
implements PDFAParser {
    private static final ReleaseDetails pdfBoxReleaseDetails = ReleaseDetails.addDetailsFromResource((String)"org/verapdf/release/pdfbox-validation.properties");
    private static final URI id = URI.create("http://pdfa.verapdf.org/parser#pdfbox");
    private static final ComponentDetails details = Components.veraDetails((URI)id, (String)"PDFBox Parser", (String)pdfBoxReleaseDetails.getVersion(), (String)"veraPDF PDFBox based model parser.");
    private static final String PDFUA_PREFIX = "ua";
    private static final Logger LOGGER = Logger.getLogger(ModelParser.class.getCanonicalName());
    private PDDocument document;
    private final PDFAFlavour flavour;

    private ModelParser(InputStream docStream, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws IOException {
        this.document = PDDocument.load((InputStream)docStream, (boolean)false, (boolean)true);
        this.flavour = ModelParser.detectFlavour(this.document, flavour, defaultFlavour);
    }

    private ModelParser(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws IOException {
        this.document = PDDocument.load((File)pdfFile, (boolean)false, (boolean)true);
        this.flavour = ModelParser.detectFlavour(this.document, flavour, defaultFlavour);
    }

    public static ModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return ModelParser.createModelWithFlavour(toLoad, flavour, PDFAFlavour.NO_FLAVOUR);
    }

    public static ModelParser createModelWithFlavour(InputStream toLoad, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws ModelParsingException, EncryptedPdfException {
        try {
            ModelParser.cleanUp();
            return new ModelParser(toLoad, flavour, defaultFlavour);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", (Throwable)excep);
        }
        catch (IOException excep) {
            throw new ModelParsingException("Couldn't parse stream", (Throwable)excep);
        }
    }

    public static ModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour) throws ModelParsingException, EncryptedPdfException {
        return ModelParser.createModelWithFlavour(pdfFile, flavour, PDFAFlavour.NO_FLAVOUR);
    }

    public static ModelParser createModelWithFlavour(File pdfFile, PDFAFlavour flavour, PDFAFlavour defaultFlavour) throws ModelParsingException, EncryptedPdfException {
        try {
            ModelParser.cleanUp();
            return new ModelParser(pdfFile, flavour, defaultFlavour);
        }
        catch (InvalidPasswordException excep) {
            throw new EncryptedPdfException("The PDF stream appears to be encrypted.", (Throwable)excep);
        }
        catch (IOException excep) {
            throw new ModelParsingException("Couldn't parse stream", (Throwable)excep);
        }
    }

    private static PDFAFlavour detectFlavour(PDDocument document, PDFAFlavour flavour, PDFAFlavour defaultFlavour) {
        if (flavour == PDFAFlavour.NO_FLAVOUR) {
            return ModelParser.obtainFlavour(document, defaultFlavour == PDFAFlavour.NO_FLAVOUR ? Foundries.defaultInstance().defaultFlavour() : defaultFlavour);
        }
        return flavour;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static PDFAFlavour obtainFlavour(PDDocument document, PDFAFlavour defaultFlavour) {
        if (document == null) return defaultFlavour;
        if (document.getDocumentCatalog() == null) {
            return defaultFlavour;
        }
        PDMetadata metadata = document.getDocumentCatalog().getMetadata();
        if (metadata == null) {
            return defaultFlavour;
        }
        try (InputStream is = metadata.exportXMPMetadata();){
            PDFAFlavour pdfaFlavour;
            VeraPDFMeta veraPDFMeta = VeraPDFMeta.parse((InputStream)is);
            Integer identificationPart = veraPDFMeta.getPDFAIdentificationPart();
            String identificationConformance = veraPDFMeta.getPDFAIdentificationConformance();
            String prefix = "";
            if (identificationPart == null && identificationConformance == null && (identificationPart = veraPDFMeta.getPDFUAIdentificationPart()) != null) {
                prefix = PDFUA_PREFIX;
            }
            if (identificationConformance == null) {
                identificationConformance = "";
            }
            if ((pdfaFlavour = PDFAFlavour.byFlavourId((String)(prefix + identificationPart + identificationConformance))) == PDFAFlavour.NO_FLAVOUR) {
                PDFAFlavour pDFAFlavour2 = defaultFlavour;
                return pDFAFlavour2;
            }
            PDFAFlavour pDFAFlavour = pdfaFlavour;
            return pDFAFlavour;
        }
        catch (IOException | XMPException e) {
            LOGGER.log(Level.SEVERE, e.getMessage());
            return defaultFlavour;
        }
    }

    private static void cleanUp() {
        StaticContainers.clearAllContainers();
        StaticXmpCoreContainers.clearAllContainers();
    }

    public PDFDocument getPDFDocument() {
        return new PDFDocumentImpl(this.document);
    }

    public ComponentDetails getDetails() {
        return details;
    }

    public Object getRoot() {
        return new PBCosDocument(this.document, this.flavour);
    }

    public PDFAFlavour getFlavour() {
        return this.flavour;
    }

    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config) {
        return PBFeatureParser.getFeaturesCollection((PDDocument)this.document, (FeatureExtractorConfig)config);
    }

    public FeatureExtractionResult getFeatures(FeatureExtractorConfig config, List<AbstractFeaturesExtractor> extractors) {
        return PBFeatureParser.getFeaturesCollection((PDDocument)this.document, extractors, (FeatureExtractorConfig)config);
    }

    public void close() {
        try {
            if (this.document != null) {
                this.document.close();
            }
        }
        catch (IOException e) {
            LOGGER.log(Level.SEVERE, "Problems with document close. " + e.getMessage());
        }
    }
}

