/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.model.impl.pb.pd;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSObjectKey;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureElement;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureNode;
import org.verapdf.model.coslayer.CosActualText;
import org.verapdf.model.coslayer.CosLang;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.impl.pb.cos.PBCosActualText;
import org.verapdf.model.impl.pb.cos.PBCosLang;
import org.verapdf.model.impl.pb.cos.PBCosUnicodeName;
import org.verapdf.model.impl.pb.exceptions.LoopedException;
import org.verapdf.model.impl.pb.pd.PBoxPDObject;
import org.verapdf.model.pdlayer.PDStructElem;
import org.verapdf.model.tools.TaggedPDFHelper;
import org.verapdf.model.tools.TaggedPDFRoleMapHelper;

public class PBoxPDStructElem
extends PBoxPDObject
implements PDStructElem {
    private static final Logger LOGGER = Logger.getLogger(PBoxPDStructElem.class.getCanonicalName());
    public static final String STRUCTURE_ELEMENT_TYPE = "PDStructElem";
    public static final String CHILDREN = "K";
    public static final String STRUCTURE_TYPE = "S";
    public static final String LANG = "Lang";
    public static final String ACTUAL_TEXT = "actualText";
    private TaggedPDFRoleMapHelper roleMapHelper;

    public PBoxPDStructElem(COSDictionary structElemDictionary, TaggedPDFRoleMapHelper roleMapHelper, String type) {
        super((COSObjectable)structElemDictionary, type);
        this.roleMapHelper = roleMapHelper;
    }

    public String getType() {
        COSBase value = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.TYPE);
        if (value instanceof COSName) {
            return ((COSName)value).getName();
        }
        LOGGER.log(Level.INFO, "In struct element type expected 'COSName' but got: " + value.getClass().getSimpleName());
        return null;
    }

    public String getkidsStandardTypes() {
        return this.getChildrenStandardTypes().stream().filter(Objects::nonNull).collect(Collectors.joining("&"));
    }

    public String getparentStandardType() {
        COSBase type;
        COSBase parent = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.P);
        if (parent != null && (type = ((COSDictionary)parent).getDictionaryObject(COSName.S)) instanceof COSName) {
            return this.roleMapHelper.getStandardType(((COSName)type).getName());
        }
        return null;
    }

    public Boolean gethasContentItems() {
        COSBase children = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.K);
        if (children != null) {
            if (PBoxPDStructElem.isContentItem(children)) {
                return true;
            }
            if (children instanceof COSArray && ((COSArray)children).size() > 0) {
                for (int i = 0; i < ((COSArray)children).size(); ++i) {
                    if (!PBoxPDStructElem.isContentItem(((COSArray)children).get(i))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    public static boolean isContentItem(COSBase base) {
        if (base instanceof COSInteger) {
            return true;
        }
        if (base instanceof COSDictionary) {
            COSName type = ((COSDictionary)base).getCOSName(COSName.TYPE);
            return type != null && (type.equals((Object)COSName.getPDFName((String)"MCR")) || type.equals((Object)COSName.getPDFName((String)"OBJR")));
        }
        return false;
    }

    public String getstandardType() {
        COSBase type = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.S);
        if (type instanceof COSName) {
            return this.roleMapHelper.getStandardType(((COSName)type).getName());
        }
        return null;
    }

    public String getparentLang() {
        COSString baseLang = null;
        HashSet<COSObjectKey> keys = new HashSet<COSObjectKey>();
        COSDictionary parentDict = (COSDictionary)((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.P);
        PDStructureNode structureParent = PDStructureNode.create((COSDictionary)parentDict);
        PDStructureElement parent = null;
        if (structureParent instanceof PDStructureElement) {
            parent = (PDStructureElement)structureParent;
        }
        while (baseLang == null && parent != null) {
            COSObjectKey key = parent.getCOSObject().getKey();
            if (keys.contains(key)) {
                throw new LoopedException("Struct tree loop found");
            }
            if (key != null) {
                keys.add(key);
            }
            baseLang = (COSString)parent.getCOSObject().getDictionaryObject(COSName.LANG);
            structureParent = parent.getParent();
            if (structureParent instanceof PDStructureElement) {
                parent = (PDStructureElement)structureParent;
                continue;
            }
            parent = null;
        }
        if (baseLang != null) {
            return baseLang.getString();
        }
        return null;
    }

    public static String getStructureElementStandardType(COSDictionary pdStructElem, TaggedPDFRoleMapHelper roleMapHelper) {
        COSBase type = pdStructElem.getDictionaryObject(COSName.S);
        if (type instanceof COSName) {
            return roleMapHelper.getStandardType(((COSName)type).getName());
        }
        return null;
    }

    public Boolean getisRemappedStandardType() {
        COSBase type = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.S);
        if (type instanceof COSName) {
            return this.roleMapHelper.isRemappedStandardType(((COSName)type).getName());
        }
        return null;
    }

    public String getAlt() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        if (pageObject != null && pageObject instanceof COSDictionary) {
            return ((COSDictionary)pageObject).getNameAsString(COSName.ALT);
        }
        return null;
    }

    public String getActualText() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        if (pageObject != null && pageObject instanceof COSDictionary) {
            return ((COSDictionary)pageObject).getNameAsString(COSName.ACTUAL_TEXT);
        }
        return null;
    }

    public String getE() {
        COSBase pageObject = this.simplePDObject.getCOSObject();
        if (pageObject != null && pageObject instanceof COSDictionary) {
            return ((COSDictionary)pageObject).getNameAsString(COSName.E);
        }
        return null;
    }

    public Boolean getcircularMappingExist() {
        COSBase type = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.S);
        if (type instanceof COSName) {
            return this.roleMapHelper.circularMappingExist(((COSName)type).getName());
        }
        return null;
    }

    public String getroleMapToSameNamespaceTag() {
        return null;
    }

    public List<? extends org.verapdf.model.baselayer.Object> getLinkedObjects(String link) {
        switch (link) {
            case "K": {
                return this.getChildren();
            }
            case "S": {
                return this.getStructureType();
            }
            case "Lang": {
                return this.getLang();
            }
            case "actualText": {
                return this.getactualText();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<String> getChildrenStandardTypes() {
        return TaggedPDFHelper.getStructElemChildrenStandardTypes((COSDictionary)this.simplePDObject, this.roleMapHelper);
    }

    public List<PDStructElem> getChildren() {
        return TaggedPDFHelper.getStructElemChildren((COSDictionary)this.simplePDObject, this.roleMapHelper);
    }

    public String getvalueS() {
        COSBase type = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.S);
        return type instanceof COSName ? ((COSName)type).getName() : null;
    }

    private List<CosUnicodeName> getStructureType() {
        COSBase type = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.S);
        if (type instanceof COSName) {
            ArrayList<PBCosUnicodeName> list = new ArrayList<PBCosUnicodeName>(1);
            list.add(new PBCosUnicodeName((COSName)type));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosLang> getLang() {
        COSBase baseLang = ((COSDictionary)this.simplePDObject).getDictionaryObject(COSName.LANG);
        if (baseLang instanceof COSString) {
            ArrayList<PBCosLang> list = new ArrayList<PBCosLang>(1);
            list.add(new PBCosLang((COSString)baseLang));
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<CosActualText> getactualText() {
        COSBase actualText;
        COSBase object = this.simplePDObject.getCOSObject();
        if (object != null && object instanceof COSDictionary && (actualText = ((COSDictionary)object).getItem(COSName.ACTUAL_TEXT)) != null && actualText instanceof COSString) {
            ArrayList<CosActualText> list = new ArrayList<CosActualText>(1);
            list.add(new PBCosActualText((COSString)actualText));
            return list;
        }
        return Collections.emptyList();
    }
}

