/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;

public final class Decrypt {
    private static final String ALIAS = "-alias";
    private static final String PASSWORD = "-password";
    private static final String KEYSTORE = "-keyStore";

    private Decrypt() {
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("apple.awt.UIElement", "true");
        Decrypt decrypt = new Decrypt();
        decrypt.decrypt(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void decrypt(String[] args) throws Exception {
        if (args.length < 2 || args.length > 5) {
            Decrypt.usage();
            return;
        }
        String password = null;
        String infile = null;
        String outfile = null;
        String alias = null;
        String keyStore = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(ALIAS)) {
                if (++i >= args.length) {
                    Decrypt.usage();
                }
                alias = args[i];
                continue;
            }
            if (args[i].equals(KEYSTORE)) {
                if (++i >= args.length) {
                    Decrypt.usage();
                }
                keyStore = args[i];
                continue;
            }
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    Decrypt.usage();
                }
                password = args[i];
                continue;
            }
            if (infile == null) {
                infile = args[i];
                continue;
            }
            if (outfile == null) {
                outfile = args[i];
                continue;
            }
            Decrypt.usage();
        }
        if (infile == null) {
            Decrypt.usage();
        }
        if (outfile == null) {
            outfile = infile;
        }
        if (password == null) {
            password = "";
        }
        PDDocument document = null;
        try {
            FileInputStream keyStoreStream = null;
            if (keyStore != null) {
                keyStoreStream = new FileInputStream(keyStore);
            }
            if ((document = PDDocument.load(new File(infile), password, (InputStream)keyStoreStream, alias)).isEncrypted()) {
                AccessPermission ap = document.getCurrentAccessPermission();
                if (!ap.isOwnerPermission()) throw new IOException("Error: You are only allowed to decrypt a document with the owner password.");
                document.setAllSecurityToBeRemoved(true);
                document.save(outfile);
                return;
            } else {
                System.err.println("Error: Document is not encrypted.");
            }
            return;
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private static void usage() {
        System.err.println("usage: java -jar pdfbox-app-x.y.z.jar Decrypt [options] <inputfile> [outputfile]");
        System.err.println("-alias      The alias of the key in the certificate file (mandatory if several keys are available)");
        System.err.println("-password   The password to open the certificate and extract the private key from it.");
        System.err.println("-keyStore   The KeyStore that holds the certificate.");
        System.exit(-1);
    }
}

