/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;

public class ExportXFDF {
    public static void main(String[] args) throws Exception {
        System.setProperty("apple.awt.UIElement", "true");
        ExportXFDF exporter = new ExportXFDF();
        exporter.exportXFDF(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void exportXFDF(String[] args) throws Exception {
        FDFDocument fdf;
        PDDocument pdf;
        block7: {
            pdf = null;
            fdf = null;
            try {
                if (args.length != 1 && args.length != 2) {
                    ExportXFDF.usage();
                    break block7;
                }
                pdf = PDDocument.load(new File(args[0]));
                PDAcroForm form = pdf.getDocumentCatalog().getAcroForm();
                if (form == null) {
                    System.err.println("Error: This PDF does not contain a form.");
                    break block7;
                }
                String fdfName = null;
                if (args.length == 2) {
                    fdfName = args[1];
                } else if (args[0].length() > 4) {
                    fdfName = args[0].substring(0, args[0].length() - 4) + ".xfdf";
                }
                fdf = form.exportFDF();
                fdf.saveXFDF(fdfName);
            }
            catch (Throwable throwable) {
                this.close(fdf);
                this.close(pdf);
                throw throwable;
            }
        }
        this.close(fdf);
        this.close(pdf);
    }

    private static void usage() {
        System.err.println("usage: org.apache.pdfbox.ExortXFDF <pdf-file> [output-xfdf-file]");
        System.err.println("    [output-xfdf-file] - Default is pdf name, test.pdf->test.xfdf");
    }

    public void close(FDFDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }

    public void close(PDDocument doc) throws IOException {
        if (doc != null) {
            doc.close();
        }
    }
}

