/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDEmbeddedFilesNameTreeNode;
import org.apache.pdfbox.pdmodel.common.filespecification.PDComplexFileSpecification;
import org.apache.pdfbox.pdmodel.common.filespecification.PDEmbeddedFile;
import org.apache.pdfbox.pdmodel.encryption.AccessPermission;
import org.apache.pdfbox.text.PDFTextStripper;
import org.apache.pdfbox.tools.PDFText2HTML;

public class ExtractText {
    private static final String PASSWORD = "-password";
    private static final String ENCODING = "-encoding";
    private static final String CONSOLE = "-console";
    private static final String START_PAGE = "-startPage";
    private static final String END_PAGE = "-endPage";
    private static final String SORT = "-sort";
    private static final String IGNORE_BEADS = "-ignoreBeads";
    private static final String DEBUG = "-debug";
    private static final String HTML = "-html";
    private boolean debug = false;

    private ExtractText() {
    }

    public static void main(String[] args) throws Exception {
        System.setProperty("apple.awt.UIElement", "true");
        ExtractText extractor = new ExtractText();
        extractor.startExtraction(args);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void startExtraction(String[] args) throws Exception {
        boolean toConsole = false;
        boolean toHTML = false;
        boolean sort = false;
        boolean separateBeads = true;
        String password = "";
        String encoding = "UTF-8";
        String pdfFile = null;
        String outputFile = null;
        String ext = ".txt";
        int startPage = 1;
        int endPage = Integer.MAX_VALUE;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(ENCODING)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                encoding = args[i];
                continue;
            }
            if (args[i].equals(START_PAGE)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                startPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(HTML)) {
                toHTML = true;
                ext = ".html";
                continue;
            }
            if (args[i].equals(SORT)) {
                sort = true;
                continue;
            }
            if (args[i].equals(IGNORE_BEADS)) {
                separateBeads = false;
                continue;
            }
            if (args[i].equals(DEBUG)) {
                this.debug = true;
                continue;
            }
            if (args[i].equals(END_PAGE)) {
                if (++i >= args.length) {
                    ExtractText.usage();
                }
                endPage = Integer.parseInt(args[i]);
                continue;
            }
            if (args[i].equals(CONSOLE)) {
                toConsole = true;
                continue;
            }
            if (pdfFile == null) {
                pdfFile = args[i];
                continue;
            }
            outputFile = args[i];
        }
        if (pdfFile == null) {
            ExtractText.usage();
            return;
        }
        OutputStreamWriter output = null;
        PDDocument document = null;
        try {
            Map embeddedFileNames;
            PDEmbeddedFilesNameTreeNode embeddedFiles;
            AccessPermission ap;
            long startTime = this.startProcessing("Loading PDF " + pdfFile);
            if (outputFile == null && pdfFile.length() > 4) {
                outputFile = new File(pdfFile.substring(0, pdfFile.length() - 4) + ext).getAbsolutePath();
            }
            if (!(ap = (document = PDDocument.load(new File(pdfFile), password)).getCurrentAccessPermission()).canExtractContent()) {
                throw new IOException("You do not have permission to extract text");
            }
            this.stopProcessing("Time for loading: ", startTime);
            output = toConsole ? new OutputStreamWriter((OutputStream)System.out, encoding) : new OutputStreamWriter((OutputStream)new FileOutputStream(outputFile), encoding);
            PDFTextStripper stripper = toHTML ? new PDFText2HTML() : new PDFTextStripper();
            stripper.setSortByPosition(sort);
            stripper.setShouldSeparateByBeads(separateBeads);
            stripper.setStartPage(startPage);
            stripper.setEndPage(endPage);
            startTime = this.startProcessing("Starting text extraction");
            if (this.debug) {
                System.err.println("Writing to " + outputFile);
            }
            stripper.writeText(document, output);
            PDDocumentCatalog catalog = document.getDocumentCatalog();
            PDDocumentNameDictionary names = catalog.getNames();
            if (names != null && (embeddedFiles = names.getEmbeddedFiles()) != null && (embeddedFileNames = embeddedFiles.getNames()) != null) {
                for (Map.Entry ent : embeddedFileNames.entrySet()) {
                    PDComplexFileSpecification spec;
                    PDEmbeddedFile file;
                    if (this.debug) {
                        System.err.println("Processing embedded file " + ent.getKey() + ":");
                    }
                    if ((file = (spec = (PDComplexFileSpecification)ent.getValue()).getEmbeddedFile()) == null || !"application/pdf".equals(file.getSubtype())) continue;
                    if (this.debug) {
                        System.err.println("  is PDF (size=" + file.getSize() + ")");
                    }
                    InputStream fis = file.createInputStream();
                    PDDocument subDoc = null;
                    try {
                        subDoc = PDDocument.load(fis);
                    }
                    finally {
                        fis.close();
                    }
                    try {
                        stripper.writeText(subDoc, output);
                    }
                    finally {
                        IOUtils.closeQuietly(subDoc);
                    }
                }
            }
            this.stopProcessing("Time for extraction: ", startTime);
        }
        catch (Throwable throwable) {
            IOUtils.closeQuietly(output);
            IOUtils.closeQuietly(document);
            throw throwable;
        }
        IOUtils.closeQuietly(output);
        IOUtils.closeQuietly(document);
    }

    private long startProcessing(String message) {
        if (this.debug) {
            System.err.println(message);
        }
        return System.currentTimeMillis();
    }

    private void stopProcessing(String message, long startTime) {
        if (this.debug) {
            long stopTime = System.currentTimeMillis();
            float elapsedTime = (float)(stopTime - startTime) / 1000.0f;
            System.err.println(message + elapsedTime + " seconds");
        }
    }

    private static void usage() {
        System.err.println("Usage: java -jar pdfbox-app-x.y.z.jar ExtractText [OPTIONS] <PDF file> [Text File]\n  -password  <password>        Password to decrypt document\n  -encoding  <output encoding> UTF-8 (default) or ISO-8859-1, UTF-16BE, UTF-16LE, etc.\n  -console                     Send text to console instead of file\n  -html                        Output in HTML format instead of raw text\n  -sort                        Sort the text before writing\n  -ignoreBeads                 Disables the separation by beads\n  -debug                       Enables debug output about the time consumption of every stage\n  -startPage <number>          The first page to start extraction(1 based)\n  -endPage <number>            The last page to extract(inclusive)\n  <PDF file>                   The PDF document to use\n  [Text File]                  The file to write the text to\n");
        System.exit(1);
    }
}

