/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.util.HashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.multipdf.Overlay;

public class OverlayPDF {
    private static final Log LOG = LogFactory.getLog(OverlayPDF.class);
    private static final String POSITION = "-position";
    private static final String ODD = "-odd";
    private static final String EVEN = "-even";
    private static final String FIRST = "-first";
    private static final String LAST = "-last";
    private static final String PAGE = "-page";
    private static final String USEALLPAGES = "-useAllPages";

    public static void main(String[] args) throws Exception {
        System.setProperty("apple.awt.UIElement", "true");
        Overlay overlayer = new Overlay();
        HashMap<Integer, String> specificPageOverlayFile = new HashMap<Integer, String>();
        for (int i = 0; i < args.length; ++i) {
            String arg = args[i].trim();
            if (i == 0) {
                overlayer.setInputFile(arg);
                continue;
            }
            if (i == args.length - 1) {
                overlayer.setOutputFile(arg);
                continue;
            }
            if (arg.equals(POSITION) && i + 1 < args.length) {
                if (Overlay.Position.FOREGROUND.toString().equalsIgnoreCase(args[i + 1].trim())) {
                    overlayer.setOverlayPosition(Overlay.Position.FOREGROUND);
                } else if (Overlay.Position.BACKGROUND.toString().equalsIgnoreCase(args[i + 1].trim())) {
                    overlayer.setOverlayPosition(Overlay.Position.BACKGROUND);
                } else {
                    OverlayPDF.usage();
                }
                ++i;
                continue;
            }
            if (arg.equals(ODD) && i + 1 < args.length) {
                overlayer.setOddPageOverlayFile(args[i + 1].trim());
                ++i;
                continue;
            }
            if (arg.equals(EVEN) && i + 1 < args.length) {
                overlayer.setEvenPageOverlayFile(args[i + 1].trim());
                ++i;
                continue;
            }
            if (arg.equals(FIRST) && i + 1 < args.length) {
                overlayer.setFirstPageOverlayFile(args[i + 1].trim());
                ++i;
                continue;
            }
            if (arg.equals(LAST) && i + 1 < args.length) {
                overlayer.setLastPageOverlayFile(args[i + 1].trim());
                ++i;
                continue;
            }
            if (arg.equals(USEALLPAGES) && i + 1 < args.length) {
                overlayer.setAllPagesOverlayFile(args[i + 1].trim());
                ++i;
                continue;
            }
            if (arg.equals(PAGE) && i + 2 < args.length && OverlayPDF.isInteger(args[i + 1].trim())) {
                specificPageOverlayFile.put(Integer.parseInt(args[i + 1].trim()), args[i + 2].trim());
                i += 2;
                continue;
            }
            if (overlayer.getDefaultOverlayFile() == null) {
                overlayer.setDefaultOverlayFile(arg);
                continue;
            }
            OverlayPDF.usage();
        }
        if (overlayer.getInputFile() == null || overlayer.getOutputFile() == null) {
            OverlayPDF.usage();
        }
        try {
            overlayer.overlay(specificPageOverlayFile);
        }
        catch (Exception e) {
            LOG.error("Overlay failed: " + e.getMessage(), e);
            throw e;
        }
    }

    private static void usage() {
        StringBuilder message = new StringBuilder();
        message.append("usage: java -jar pdfbox-app-x.y.z.jar OverlayPDF <input.pdf> [OPTIONS] <output.pdf>\n");
        message.append("  <input.pdf>                                        input file\n");
        message.append("  <defaultOverlay.pdf>                               default overlay file\n");
        message.append("  -odd <oddPageOverlay.pdf>                          overlay file used for odd pages\n");
        message.append("  -even <evenPageOverlay.pdf>                        overlay file used for even pages\n");
        message.append("  -first <firstPageOverlay.pdf>                      overlay file used for the first page\n");
        message.append("  -last <lastPageOverlay.pdf>                        overlay file used for the last page\n");
        message.append("  -useAllPages <allPagesOverlay.pdf>                 overlay file used for overlay, all pages are used by simply repeating them\n");
        message.append("  -page <pageNumber> <specificPageOverlay.pdf>       overlay file used for the given page number, may occur more than once\n");
        message.append("  -position foreground|background                    where to put the overlay file: foreground or background\n");
        message.append("  <output.pdf>                                       output file\n");
        System.err.println(message.toString());
        System.exit(1);
    }

    private static boolean isInteger(String str) {
        try {
            Integer.parseInt(str);
        }
        catch (NumberFormatException nfe) {
            return false;
        }
        return true;
    }
}

