/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class TextToPDF {
    private int fontSize = 10;
    private PDFont font = PDType1Font.HELVETICA;
    private static final Map<String, PDType1Font> STANDARD_14 = new HashMap<String, PDType1Font>();

    public PDDocument createPDFFromText(Reader text) throws IOException {
        PDDocument doc = new PDDocument();
        this.createPDFFromText(doc, text);
        return doc;
    }

    public void createPDFFromText(PDDocument doc, Reader text) throws IOException {
        try {
            int margin = 40;
            float height = this.font.getBoundingBox().getHeight() / 1000.0f;
            height = height * (float)this.fontSize * 1.05f;
            BufferedReader data = new BufferedReader(text);
            String nextLine = null;
            PDPage page = new PDPage();
            PDPageContentStream contentStream = null;
            float y = -1.0f;
            float maxStringLength = page.getMediaBox().getWidth() - 80.0f;
            boolean textIsEmpty = true;
            while ((nextLine = data.readLine()) != null) {
                textIsEmpty = false;
                String[] lineWords = nextLine.trim().split(" ");
                int lineIndex = 0;
                while (lineIndex < lineWords.length) {
                    StringBuffer nextLineToDraw = new StringBuffer();
                    float lengthIfUsingNextWord = 0.0f;
                    do {
                        nextLineToDraw.append(lineWords[lineIndex]);
                        nextLineToDraw.append(" ");
                        if (++lineIndex >= lineWords.length) continue;
                        String lineWithNextWord = nextLineToDraw.toString() + lineWords[lineIndex];
                        lengthIfUsingNextWord = this.font.getStringWidth(lineWithNextWord) / 1000.0f * (float)this.fontSize;
                    } while (lineIndex < lineWords.length && lengthIfUsingNextWord < maxStringLength);
                    if (y < 40.0f) {
                        page = new PDPage();
                        doc.addPage(page);
                        if (contentStream != null) {
                            contentStream.endText();
                            contentStream.close();
                        }
                        contentStream = new PDPageContentStream(doc, page);
                        contentStream.setFont(this.font, this.fontSize);
                        contentStream.beginText();
                        y = page.getMediaBox().getHeight() - 40.0f + height;
                        contentStream.newLineAtOffset(40.0f, y);
                    }
                    if (contentStream == null) {
                        throw new IOException("Error:Expected non-null content stream.");
                    }
                    contentStream.newLineAtOffset(0.0f, -height);
                    y -= height;
                    contentStream.showText(nextLineToDraw.toString());
                }
            }
            if (textIsEmpty) {
                doc.addPage(page);
            }
            if (contentStream != null) {
                contentStream.endText();
                contentStream.close();
            }
        }
        catch (IOException io) {
            if (doc != null) {
                doc.close();
            }
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        TextToPDF app = new TextToPDF();
        PDDocument doc = new PDDocument();
        try {
            if (args.length < 2) {
                app.usage();
            } else {
                for (int i = 0; i < args.length - 2; ++i) {
                    if (args[i].equals("-standardFont")) {
                        app.setFont(TextToPDF.getStandardFont(args[++i]));
                        continue;
                    }
                    if (args[i].equals("-ttf")) {
                        PDType0Font font = PDType0Font.load(doc, new File(args[++i]));
                        app.setFont(font);
                        continue;
                    }
                    if (args[i].equals("-fontSize")) {
                        app.setFontSize(Integer.parseInt(args[++i]));
                        continue;
                    }
                    throw new IOException("Unknown argument:" + args[i]);
                }
                app.createPDFFromText(doc, new FileReader(args[args.length - 1]));
                doc.save(args[args.length - 2]);
            }
        }
        finally {
            doc.close();
        }
    }

    private void usage() {
        String[] std14 = TextToPDF.getStandard14Names();
        System.err.println("usage: jar -jar pdfbox-app-x.y.z.jar TextToPDF [options] <output-file> <text-file>");
        System.err.println("    -standardFont <name>    default:" + PDType1Font.HELVETICA.getBaseFont());
        for (String std14String : std14) {
            System.err.println("                                    " + std14String);
        }
        System.err.println("    -ttf <ttf file>         The TTF font to use.");
        System.err.println("    -fontSize <fontSize>    default:10");
    }

    private static PDType1Font getStandardFont(String name) {
        return STANDARD_14.get(name);
    }

    private static String[] getStandard14Names() {
        return STANDARD_14.keySet().toArray(new String[14]);
    }

    public PDFont getFont() {
        return this.font;
    }

    public void setFont(PDFont aFont) {
        this.font = aFont;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int aFontSize) {
        this.fontSize = aFontSize;
    }

    static {
        STANDARD_14.put(PDType1Font.TIMES_ROMAN.getBaseFont(), PDType1Font.TIMES_ROMAN);
        STANDARD_14.put(PDType1Font.TIMES_BOLD.getBaseFont(), PDType1Font.TIMES_BOLD);
        STANDARD_14.put(PDType1Font.TIMES_ITALIC.getBaseFont(), PDType1Font.TIMES_ITALIC);
        STANDARD_14.put(PDType1Font.TIMES_BOLD_ITALIC.getBaseFont(), PDType1Font.TIMES_BOLD_ITALIC);
        STANDARD_14.put(PDType1Font.HELVETICA.getBaseFont(), PDType1Font.HELVETICA);
        STANDARD_14.put(PDType1Font.HELVETICA_BOLD.getBaseFont(), PDType1Font.HELVETICA_BOLD);
        STANDARD_14.put(PDType1Font.HELVETICA_OBLIQUE.getBaseFont(), PDType1Font.HELVETICA_OBLIQUE);
        STANDARD_14.put(PDType1Font.HELVETICA_BOLD_OBLIQUE.getBaseFont(), PDType1Font.HELVETICA_BOLD_OBLIQUE);
        STANDARD_14.put(PDType1Font.COURIER.getBaseFont(), PDType1Font.COURIER);
        STANDARD_14.put(PDType1Font.COURIER_BOLD.getBaseFont(), PDType1Font.COURIER_BOLD);
        STANDARD_14.put(PDType1Font.COURIER_OBLIQUE.getBaseFont(), PDType1Font.COURIER_OBLIQUE);
        STANDARD_14.put(PDType1Font.COURIER_BOLD_OBLIQUE.getBaseFont(), PDType1Font.COURIER_BOLD_OBLIQUE);
        STANDARD_14.put(PDType1Font.SYMBOL.getBaseFont(), PDType1Font.SYMBOL);
        STANDARD_14.put(PDType1Font.ZAPF_DINGBATS.getBaseFont(), PDType1Font.ZAPF_DINGBATS);
    }
}

