/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools.pdfdebugger.pagepane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PagePane {
    private JPanel panel;
    private int pageIndex = -1;
    private final PDDocument document;
    private JLabel label;

    public PagePane(PDDocument document, COSDictionary page) {
        PDPage pdPage = new PDPage(page);
        this.pageIndex = document.getPages().indexOf(pdPage);
        this.document = document;
        this.initUI();
    }

    private void initUI() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        String pageLabelText = this.pageIndex < 0 ? "Page number not found" : "Page " + (this.pageIndex + 1);
        JLabel pageLabel = new JLabel(pageLabelText);
        pageLabel.setAlignmentX(0.5f);
        pageLabel.setFont(new Font("Monospaced", 1, 30));
        pageLabel.setBackground(Color.GREEN);
        this.panel.add(pageLabel);
        this.label = new JLabel();
        this.label.setBackground(this.panel.getBackground());
        this.label.setAlignmentX(0.5f);
        this.label.setText("Loading...");
        this.panel.add(this.label);
        new RenderWorker().execute();
    }

    public Component getPanel() {
        return this.panel;
    }

    private class RenderWorker
    extends SwingWorker<BufferedImage, Integer> {
        private RenderWorker() {
        }

        @Override
        protected BufferedImage doInBackground() throws IOException {
            PDFRenderer renderer = new PDFRenderer(PagePane.this.document);
            return renderer.renderImage(PagePane.this.pageIndex);
        }

        @Override
        protected void done() {
            try {
                PagePane.this.label.setIcon(new ImageIcon((Image)this.get()));
                PagePane.this.label.setText(null);
            }
            catch (InterruptedException e) {
                PagePane.this.label.setText(e.getMessage());
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                PagePane.this.label.setText(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }
}

