/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.GregorianCalendar;
import java.util.List;
import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.datatype.DatatypeConfigurationException;
import javax.xml.datatype.DatatypeFactory;
import javax.xml.datatype.XMLGregorianCalendar;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.AbstractEmbeddedFileFeaturesExtractor;
import org.verapdf.features.EmbeddedFileFeaturesData;
import org.verapdf.features.tools.FeatureTreeNode;

public class EmbeddedFileSampleExtractor
extends AbstractEmbeddedFileFeaturesExtractor {
    private static final Logger LOGGER = Logger.getLogger(EmbeddedFileSampleExtractor.class.getCanonicalName());

    public List<FeatureTreeNode> getEmbeddedFileFeatures(EmbeddedFileFeaturesData embeddedFileFeaturesData) {
        ArrayList<FeatureTreeNode> res = new ArrayList<FeatureTreeNode>();
        try {
            EmbeddedFileSampleExtractor.addObjectNode("checkSum", embeddedFileFeaturesData.getCheckSum(), res);
            EmbeddedFileSampleExtractor.addObjectNode("creationDate", EmbeddedFileSampleExtractor.formatXMLDate(embeddedFileFeaturesData.getCreationDate()), res);
            EmbeddedFileSampleExtractor.addObjectNode("description", embeddedFileFeaturesData.getDescription(), res);
            EmbeddedFileSampleExtractor.addObjectNode("modDate", EmbeddedFileSampleExtractor.formatXMLDate(embeddedFileFeaturesData.getModDate()), res);
            EmbeddedFileSampleExtractor.addObjectNode("name", embeddedFileFeaturesData.getName(), res);
            EmbeddedFileSampleExtractor.addObjectNode("size", embeddedFileFeaturesData.getSize(), res);
            EmbeddedFileSampleExtractor.addObjectNode("subtype", embeddedFileFeaturesData.getSubtype(), res);
        }
        catch (DatatypeConfigurationException | FeatureParsingException e) {
            LOGGER.log(Level.WARNING, "IO/Exception when adding information", e);
        }
        return res;
    }

    private static void addObjectNode(String nodeName, Object toAdd, List<FeatureTreeNode> list) throws FeatureParsingException {
        if (toAdd != null) {
            FeatureTreeNode node = FeatureTreeNode.createRootNode((String)nodeName);
            node.setValue(toAdd.toString());
            list.add(node);
        }
    }

    private static String formatXMLDate(Calendar calendar) throws DatatypeConfigurationException {
        if (calendar == null) {
            return null;
        }
        GregorianCalendar greg = new GregorianCalendar(Locale.US);
        greg.setTime(calendar.getTime());
        greg.setTimeZone(calendar.getTimeZone());
        XMLGregorianCalendar xmlCalendar = DatatypeFactory.newInstance().newXMLGregorianCalendar(greg);
        return xmlCalendar.toXMLFormat();
    }
}

