/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.AbstractFontFeaturesExtractor;
import org.verapdf.features.FontFeaturesData;
import org.verapdf.features.tools.FeatureTreeNode;

public class FontSampleExtractor
extends AbstractFontFeaturesExtractor {
    private static final Logger LOGGER = Logger.getLogger(FontSampleExtractor.class.getCanonicalName());

    public List<FeatureTreeNode> getFontFeatures(FontFeaturesData fontFeaturesData) {
        ArrayList<FeatureTreeNode> res = new ArrayList<FeatureTreeNode>();
        try {
            InputStream metadataStream = fontFeaturesData.getMetadata();
            if (metadataStream != null) {
                FeatureTreeNode metadata = FeatureTreeNode.createRootNode((String)"metadataStreamContent");
                metadata.setValue(DatatypeConverter.printHexBinary((byte[])FontSampleExtractor.inputStreamToByteArray(metadataStream)));
                res.add(metadata);
            }
            FontSampleExtractor.addObjectNode("ascent", fontFeaturesData.getAscent(), res);
            FontSampleExtractor.addObjectNode("avgWidth", fontFeaturesData.getAvgWidth(), res);
            FontSampleExtractor.addObjectNode("capHeight", fontFeaturesData.getCapHeight(), res);
            FontSampleExtractor.addObjectNode("charSet", fontFeaturesData.getCharSet(), res);
            FontSampleExtractor.addObjectNode("descent", fontFeaturesData.getDescent(), res);
            FontSampleExtractor.addObjectNode("flags", fontFeaturesData.getFlags(), res);
            List bbox = fontFeaturesData.getFontBBox();
            if (bbox != null) {
                FeatureTreeNode rangeNode = FeatureTreeNode.createRootNode((String)"fontBBox");
                res.add(rangeNode);
                for (int i = 0; i < bbox.size(); ++i) {
                    Double obj = (Double)bbox.get(i);
                    if (obj == null) continue;
                    FeatureTreeNode entry = rangeNode.addChild("entry");
                    entry.setValue(obj.toString());
                    entry.setAttribute("index", String.valueOf(i));
                }
            }
            FontSampleExtractor.addObjectNode("fontFamily", fontFeaturesData.getFontFamily(), res);
            FontSampleExtractor.addObjectNode("fontName", fontFeaturesData.getFontName(), res);
            FontSampleExtractor.addObjectNode("fontStretch", fontFeaturesData.getFontStretch(), res);
            FontSampleExtractor.addObjectNode("fontWeight", fontFeaturesData.getFontWeight(), res);
            FontSampleExtractor.addObjectNode("italicAngle", fontFeaturesData.getItalicAngle(), res);
            FontSampleExtractor.addObjectNode("leading", fontFeaturesData.getLeading(), res);
            FontSampleExtractor.addObjectNode("maxWidth", fontFeaturesData.getMaxWidth(), res);
            FontSampleExtractor.addObjectNode("missingWidth", fontFeaturesData.getMissingWidth(), res);
            FontSampleExtractor.addObjectNode("stemH", fontFeaturesData.getStemH(), res);
            FontSampleExtractor.addObjectNode("stemV", fontFeaturesData.getStemV(), res);
            FontSampleExtractor.addObjectNode("xHeight", fontFeaturesData.getXHeight(), res);
        }
        catch (FeatureParsingException e) {
            LOGGER.log(Level.WARNING, "Some fail in logic", e);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return res;
    }

    private static FeatureTreeNode addObjectNode(String nodeName, Object toAdd, List<FeatureTreeNode> list) throws FeatureParsingException {
        FeatureTreeNode node = null;
        if (toAdd != null) {
            node = FeatureTreeNode.createRootNode((String)nodeName);
            list.add(node);
            node.setValue(toAdd.toString());
        }
        return node;
    }

    private static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((length = is.read(bytes)) != -1) {
            baos.write(bytes, 0, length);
        }
        return baos.toByteArray();
    }
}

