/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.bind.DatatypeConverter;
import org.verapdf.core.FeatureParsingException;
import org.verapdf.features.AbstractImageFeaturesExtractor;
import org.verapdf.features.ImageFeaturesData;
import org.verapdf.features.tools.FeatureTreeNode;

public class ImageSampleExtractor
extends AbstractImageFeaturesExtractor {
    private static final Logger LOGGER = Logger.getLogger(ImageSampleExtractor.class.getCanonicalName());

    public List<FeatureTreeNode> getImageFeatures(ImageFeaturesData imageFeaturesData) {
        ArrayList<FeatureTreeNode> res = new ArrayList<FeatureTreeNode>();
        try {
            FeatureTreeNode stream = FeatureTreeNode.createRootNode((String)"streamContent");
            stream.setValue(DatatypeConverter.printHexBinary((byte[])ImageSampleExtractor.inputStreamToByteArray(imageFeaturesData.getStream())));
            res.add(stream);
            InputStream meta = imageFeaturesData.getMetadata();
            if (meta != null) {
                FeatureTreeNode metadata = FeatureTreeNode.createRootNode((String)"metadataStreamContent");
                metadata.setValue(DatatypeConverter.printHexBinary((byte[])ImageSampleExtractor.inputStreamToByteArray(meta)));
                res.add(metadata);
            }
            ImageSampleExtractor.addObjectNode("width", imageFeaturesData.getWidth(), res);
            ImageSampleExtractor.addObjectNode("height", imageFeaturesData.getHeight(), res);
            List filters = imageFeaturesData.getFilters();
            if (filters != null) {
                FeatureTreeNode filtersNode = FeatureTreeNode.createRootNode((String)"filters");
                res.add(filtersNode);
                for (ImageFeaturesData.Filter filter : filters) {
                    InputStream streamF;
                    FeatureTreeNode filterNode = filtersNode.addChild("filter");
                    filterNode.setAttribute("name", String.valueOf(filter.getName()));
                    Map properties = filter.getProperties();
                    if (properties != null) {
                        for (Map.Entry entry : properties.entrySet()) {
                            filterNode.addChild(String.valueOf(entry.getKey())).setValue(String.valueOf(entry.getValue()));
                        }
                    }
                    if ((streamF = filter.getStream()) == null) continue;
                    String streamContent = DatatypeConverter.printHexBinary((byte[])ImageSampleExtractor.inputStreamToByteArray(streamF));
                    filterNode.addChild("stream").setValue(streamContent);
                }
            }
        }
        catch (IOException | FeatureParsingException e) {
            LOGGER.log(Level.WARNING, "Some fail in logic", e);
        }
        return res;
    }

    private static FeatureTreeNode addObjectNode(String nodeName, Object toAdd, List<FeatureTreeNode> list) throws FeatureParsingException {
        FeatureTreeNode node = null;
        if (toAdd != null) {
            node = FeatureTreeNode.createRootNode((String)nodeName);
            list.add(node);
            node.setValue(toAdd.toString());
        }
        return node;
    }

    private static byte[] inputStreamToByteArray(InputStream is) throws IOException {
        int length;
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        byte[] bytes = new byte[1024];
        while ((length = is.read(bytes)) != -1) {
            baos.write(bytes, 0, length);
        }
        return baos.toByteArray();
    }
}

