/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.StringWriter;
import java.io.Writer;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;

@XmlRootElement(namespace="http://www.verapdf.org/MediaConchConfig", name="mediaconchConfig")
final class MediaConchConfig {
    @XmlElement
    private final String cliPath;
    @XmlElement
    private final String outFolder;

    private MediaConchConfig() {
        this("", "");
    }

    private MediaConchConfig(String outFolder, String cliPath) {
        this.outFolder = outFolder;
        this.cliPath = cliPath;
    }

    public String getCliPath() {
        return this.cliPath;
    }

    public String getOutFolder() {
        return this.outFolder;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MediaConchConfig that = (MediaConchConfig)o;
        if (this.cliPath != null ? !this.cliPath.equals(that.cliPath) : that.cliPath != null) {
            return false;
        }
        return !(this.outFolder == null ? that.outFolder != null : !this.outFolder.equals(that.outFolder));
    }

    public int hashCode() {
        int result = this.cliPath != null ? this.cliPath.hashCode() : 0;
        result = 31 * result + (this.outFolder != null ? this.outFolder.hashCode() : 0);
        return result;
    }

    static MediaConchConfig defaultInstance() {
        return new MediaConchConfig("mediaconch", null);
    }

    static MediaConchConfig fromValues(String cliPath, String outFolder) {
        return new MediaConchConfig(cliPath, outFolder);
    }

    static String toXml(MediaConchConfig toConvert, Boolean prettyXml) throws JAXBException, IOException {
        String retVal = "";
        try (StringWriter writer = new StringWriter();){
            MediaConchConfig.toXml(toConvert, writer, prettyXml);
            String string = retVal = writer.toString();
            return string;
        }
    }

    static MediaConchConfig fromXml(String toConvert) throws JAXBException {
        try (StringReader reader = new StringReader(toConvert);){
            MediaConchConfig mediaConchConfig = MediaConchConfig.fromXml(reader);
            return mediaConchConfig;
        }
    }

    static void toXml(MediaConchConfig toConvert, OutputStream stream, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = MediaConchConfig.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, stream);
    }

    static MediaConchConfig fromXml(InputStream toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = MediaConchConfig.getUnmarshaller();
        return (MediaConchConfig)stringUnmarshaller.unmarshal(toConvert);
    }

    static void toXml(MediaConchConfig toConvert, Writer writer, Boolean prettyXml) throws JAXBException {
        Marshaller varMarshaller = MediaConchConfig.getMarshaller(prettyXml);
        varMarshaller.marshal((Object)toConvert, writer);
    }

    static MediaConchConfig fromXml(Reader toConvert) throws JAXBException {
        Unmarshaller stringUnmarshaller = MediaConchConfig.getUnmarshaller();
        return (MediaConchConfig)stringUnmarshaller.unmarshal(toConvert);
    }

    private static Unmarshaller getUnmarshaller() throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MediaConchConfig.class});
        return context.createUnmarshaller();
    }

    private static Marshaller getMarshaller(Boolean setPretty) throws JAXBException {
        JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{MediaConchConfig.class});
        Marshaller marshaller = context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)setPretty);
        return marshaller;
    }
}

