/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.gfse.contents;

import java.util.HashSet;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.gf.model.impl.pd.gfse.contents.GFSEContentItem;
import org.verapdf.model.operator.Operator;
import org.verapdf.model.selayer.SEGroupedContent;
import org.verapdf.pd.structure.PDStructElem;
import org.verapdf.tools.StaticResources;
import org.verapdf.tools.TaggedPDFRoleMapHelper;

public abstract class GFSEGroupedContent
extends GFSEContentItem
implements SEGroupedContent {
    private static final Logger LOGGER = Logger.getLogger(GFSEGroupedContent.class.getCanonicalName());
    protected final List<Operator> operators;
    protected final COSObject parentStructElem;
    protected final List<String> parentsTags;
    protected final boolean isSignature;
    protected final String defaultLang;
    protected final Boolean isTaggedContent;

    public GFSEGroupedContent(String objectType, List<Operator> operators, COSObject parentStructElem, List<String> parentsTags, String defaultLang, boolean isSignature) {
        super(objectType);
        this.operators = operators;
        this.parentStructElem = parentStructElem;
        this.parentsTags = parentsTags;
        this.defaultLang = defaultLang;
        this.isSignature = isSignature;
        this.isTaggedContent = this.isTaggedContent();
    }

    public List<String> getparentsTags() {
        return this.parentsTags;
    }

    public String getparentStructureTag() {
        return this.parentStructElem != null ? this.parentStructElem.getNameKeyStringValue(ASAtom.S) : null;
    }

    public String getparentStandardTag() {
        TaggedPDFRoleMapHelper taggedPDFRoleMapHelper = StaticResources.getRoleMapHelper();
        if (this.parentStructElem != null && taggedPDFRoleMapHelper != null) {
            PDStructElem structElem = new PDStructElem(this.parentStructElem);
            return PDStructElem.getStructureElementStandardType((PDStructElem)structElem);
        }
        return null;
    }

    public Boolean getisSignature() {
        return this.isSignature;
    }

    public String getLangValue() {
        return this.defaultLang;
    }

    public Boolean getisArtifact() {
        return this.hasParentWithStandardType("Artifact");
    }

    protected Boolean hasParentWithStandardType(String standardType) {
        TaggedPDFRoleMapHelper taggedPDFRoleMapHelper = StaticResources.getRoleMapHelper();
        if (this.parentStructElem != null && taggedPDFRoleMapHelper != null) {
            HashSet<COSKey> keys = new HashSet<COSKey>();
            for (PDStructElem structElem = new PDStructElem(this.parentStructElem); structElem != null; structElem = structElem.getParent()) {
                if (standardType.equals(PDStructElem.getStructureElementStandardType((PDStructElem)structElem))) {
                    return true;
                }
                COSKey key = structElem.getObject().getObjectKey();
                if (keys.contains(key)) {
                    LOGGER.log(Level.WARNING, "Struct tree loop found");
                    break;
                }
                if (key == null) continue;
                keys.add(key);
            }
        }
        return false;
    }

    public String getInheritedActualText() {
        return null;
    }

    public String getInheritedAlt() {
        return null;
    }

    public Long getMCID() {
        return null;
    }

    public String getActualText() {
        return null;
    }

    public String getAlt() {
        return null;
    }

    public Boolean getisTaggedContent() {
        return this.isTaggedContent;
    }

    private boolean isTaggedContent() {
        HashSet<COSKey> keys = new HashSet<COSKey>();
        for (PDStructElem structElem = new PDStructElem(this.parentStructElem); structElem != null; structElem = structElem.getParent()) {
            if (structElem.getType() == ASAtom.STRUCT_TREE_ROOT) {
                return true;
            }
            COSKey key = structElem.getObject().getObjectKey();
            if (keys.contains(key)) {
                LOGGER.log(Level.WARNING, "Struct tree loop found");
                break;
            }
            if (key == null) continue;
            keys.add(key);
        }
        return false;
    }

    public String getparentStructureElementObjectKey() {
        return this.parentStructElem.getObjectKey().toString();
    }
}

