/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.external;

import org.verapdf.external.JPEG2000;
import org.verapdf.gf.model.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.impl.external.GFExternal;
import org.verapdf.model.pdlayer.PDColorSpace;

public class GFJPEG2000
extends GFExternal
implements org.verapdf.model.external.JPEG2000 {
    public static final String JPEG_2000_TYPE = "JPEG2000";
    private final JPEG2000 jpeg2000;
    private final boolean hasColorSpace;

    public GFJPEG2000(JPEG2000 jpeg2000, boolean hasColorSpace) {
        super(JPEG_2000_TYPE);
        this.jpeg2000 = jpeg2000;
        this.hasColorSpace = hasColorSpace;
    }

    public Long getnrColorChannels() {
        return this.jpeg2000.getNumberOfColorChannels();
    }

    public Long getnrColorSpaceSpecs() {
        return this.jpeg2000.getNumberOfColorSpaceSpecs();
    }

    public Long getnrColorSpacesWithApproxField() {
        return this.jpeg2000.getNumberOfColorSpacesWithApproxField();
    }

    public Long getcolrMethod() {
        return this.jpeg2000.getColrMethod();
    }

    public Long getcolrEnumCS() {
        return this.jpeg2000.getColrEnumCS();
    }

    public Long getbitDepth() {
        return this.jpeg2000.getBitDepth();
    }

    public Boolean getbpccBoxPresent() {
        return this.jpeg2000.getBPCCBoxPresent();
    }

    public Boolean gethasColorSpace() {
        return this.hasColorSpace;
    }

    public PDColorSpace getImageColorSpace() {
        return ColorSpaceFactory.getColorSpace(this.jpeg2000.getImageColorSpace());
    }
}

