/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.cos;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.verapdf.cos.COSArray;
import org.verapdf.cos.COSBase;
import org.verapdf.cos.COSNumber;
import org.verapdf.gf.model.impl.cos.GFCosArray;
import org.verapdf.model.coslayer.CosBBox;

public class GFCosBBox
extends GFCosArray
implements CosBBox {
    private static final Logger LOGGER = Logger.getLogger(GFCosBBox.class.getCanonicalName());
    public static final String COS_BBOX_TYPE = "CosBBox";
    private static final int LEFT_CORNER_POSITION = 0;
    private static final int BOTTOM_CORNER_POSITION = 1;
    private static final int RIGHT_CORNER_POSITION = 2;
    private static final int TOP_CORNER_POSITION = 3;

    public GFCosBBox(COSArray array) {
        super(array, COS_BBOX_TYPE);
    }

    public Double gettop() {
        return this.getRequiredValue(3);
    }

    public Double getbottom() {
        return this.getRequiredValue(1);
    }

    public Double getleft() {
        return this.getRequiredValue(0);
    }

    public Double getright() {
        return this.getRequiredValue(2);
    }

    private Double getRequiredValue(int position) {
        COSArray array = (COSArray)this.baseObject;
        if (array.size() > position) {
            COSBase base = array.at(position).get();
            if (base instanceof COSNumber) {
                return base.getReal();
            }
            LOGGER.log(Level.WARNING, "In bbox expected number but got " + base.getClass().getSimpleName());
        } else {
            LOGGER.log(Level.WARNING, "Expected size of bbox array greater than" + position + "but got " + array.size());
        }
        return null;
    }
}

