/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.impl.pd.colors;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSName;
import org.verapdf.cos.COSObjType;
import org.verapdf.cos.COSObject;
import org.verapdf.factory.colors.ColorSpaceFactory;
import org.verapdf.gf.model.impl.cos.GFCosUnicodeName;
import org.verapdf.gf.model.impl.pd.colors.GFPDColorSpace;
import org.verapdf.gf.model.impl.pd.colors.GFPDSeparation;
import org.verapdf.model.baselayer.Object;
import org.verapdf.model.coslayer.CosUnicodeName;
import org.verapdf.model.pdlayer.PDSeparation;
import org.verapdf.pd.colors.PDColorSpace;
import org.verapdf.pd.colors.PDDeviceN;

public class GFPDDeviceN
extends GFPDColorSpace
implements org.verapdf.model.pdlayer.PDDeviceN {
    public static final String DEVICE_N_TYPE = "PDDeviceN";
    public static final String ALTERNATE = "alternate";
    public static final String COLORANT_NAMES = "colorantNames";
    public static final String COLORANTS = "Colorants";
    private final boolean areColorantsPresent;

    public GFPDDeviceN(PDDeviceN simplePDObject) {
        super((PDColorSpace)simplePDObject, DEVICE_N_TYPE);
        this.areColorantsPresent = GFPDDeviceN.areColorantsPresent(simplePDObject);
    }

    private static boolean areColorantsPresent(PDDeviceN simplePDObject) {
        COSObject colorantsDict;
        COSObject attributes = simplePDObject.getAttributes();
        if (attributes != null && attributes.getType() == COSObjType.COS_DICT && (colorantsDict = attributes.getKey(ASAtom.COLORANTS)) != null && colorantsDict.getType() == COSObjType.COS_DICT) {
            List colorantsArray = simplePDObject.getNames();
            return GFPDDeviceN.areColorantsPresent(colorantsDict, colorantsArray);
        }
        return false;
    }

    private static boolean areColorantsPresent(COSObject colorantsDict, List<COSObject> colorantsArray) {
        Set colorantDictionaryEntries = colorantsDict.getKeySet();
        for (int i = 0; i < colorantsArray.size(); ++i) {
            COSObject object = colorantsArray.get(i);
            if (object == null || colorantDictionaryEntries.contains(object.getName())) continue;
            return false;
        }
        return true;
    }

    public Boolean getareColorantsPresent() {
        return this.areColorantsPresent;
    }

    public List<? extends Object> getLinkedObjects(String link) {
        switch (link) {
            case "alternate": {
                return this.getAlternate();
            }
            case "colorantNames": {
                return this.getColorantNames();
            }
            case "Colorants": {
                return this.getColorants();
            }
        }
        return super.getLinkedObjects(link);
    }

    private List<org.verapdf.model.pdlayer.PDColorSpace> getAlternate() {
        PDColorSpace alternateColorSpace = ((PDDeviceN)this.simplePDObject).getAlternateSpace();
        org.verapdf.model.pdlayer.PDColorSpace space = org.verapdf.gf.model.factory.colors.ColorSpaceFactory.getColorSpace(alternateColorSpace);
        if (space != null) {
            ArrayList<org.verapdf.model.pdlayer.PDColorSpace> colorSpace = new ArrayList<org.verapdf.model.pdlayer.PDColorSpace>(1);
            colorSpace.add(space);
            return Collections.unmodifiableList(colorSpace);
        }
        return Collections.emptyList();
    }

    private List<CosUnicodeName> getColorantNames() {
        List colorants = ((PDDeviceN)this.simplePDObject).getNames();
        if (!colorants.isEmpty()) {
            ArrayList<GFCosUnicodeName> list = new ArrayList<GFCosUnicodeName>(colorants.size());
            for (COSObject colorant : colorants) {
                if (colorant.getType() != COSObjType.COS_NAME) continue;
                list.add(new GFCosUnicodeName((COSName)colorant.getDirectBase()));
            }
            return Collections.unmodifiableList(list);
        }
        return Collections.emptyList();
    }

    private List<PDSeparation> getColorants() {
        COSObject colorantsDict;
        COSObject attributes = ((PDDeviceN)this.simplePDObject).getAttributes();
        if (attributes != null && attributes.getType() == COSObjType.COS_DICT && (colorantsDict = attributes.getKey(ASAtom.COLORANTS)).getType() == COSObjType.COS_DICT && colorantsDict.size() > 0) {
            return GFPDDeviceN.getColorants(colorantsDict);
        }
        return Collections.emptyList();
    }

    private static List<PDSeparation> getColorants(COSObject colorantsDict) {
        ArrayList<GFPDSeparation> list = new ArrayList<GFPDSeparation>(colorantsDict.size());
        for (COSObject value : colorantsDict.getValues()) {
            PDColorSpace colorSpace = ColorSpaceFactory.getColorSpace((COSObject)value);
            if (!ASAtom.SEPARATION.equals((java.lang.Object)colorSpace.getType())) continue;
            list.add((GFPDSeparation)org.verapdf.gf.model.factory.colors.ColorSpaceFactory.getColorSpace(colorSpace));
        }
        return Collections.unmodifiableList(list);
    }
}

