/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.tools;

import org.verapdf.as.ASAtom;
import org.verapdf.cos.COSKey;
import org.verapdf.cos.COSObject;
import org.verapdf.pd.PDOutlineItem;
import org.verapdf.pd.font.PDFont;
import org.verapdf.pd.font.PDType0Font;

public final class GFIDGenerator {
    private GFIDGenerator() {
    }

    public static String generateID(COSKey key) {
        return String.valueOf(key.getNumber() + " " + key.getGeneration());
    }

    public static String generateID(PDFont font) {
        if (font instanceof PDType0Font) {
            return GFIDGenerator.generateID((PDType0Font)font);
        }
        int hashcode = font.getDictionary().hashCode();
        return String.valueOf(hashcode) + ' ' + font.getName();
    }

    public static String generateID(PDType0Font font) {
        int hashcode = font.getType0FontDict().hashCode();
        return String.valueOf(hashcode) + ' ' + font.getName();
    }

    public static String generateID(int hashcode, String fontName, int glyphCode, int renderingMode) {
        return String.valueOf(hashcode) + ' ' + fontName + ' ' + glyphCode + ' ' + renderingMode;
    }

    public static String generateID(PDOutlineItem item) {
        COSObject dictionary = item.getObject();
        String value = GFIDGenerator.getOutlineID(dictionary, ASAtom.PREV, ASAtom.NEXT);
        return value != null ? value : GFIDGenerator.getOutlineID(dictionary, ASAtom.PARENT, ASAtom.FIRST);
    }

    private static String getOutlineID(COSObject dictionary, ASAtom kind, ASAtom key) {
        COSObject current;
        COSObject base = dictionary.getKey(kind);
        if (base != null && base.getType().isDictionaryBased() && (current = base.getKey(key)) != null && current.getKey() != null) {
            String value = GFIDGenerator.generateID(current.getKey());
            return "outline " + value;
        }
        return null;
    }
}

