/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.gf.model.factory.operators;

public enum RenderingMode {
    FILL(0),
    STROKE(1),
    FILL_STROKE(2),
    NEITHER(3),
    FILL_CLIP(4),
    STROKE_CLIP(5),
    FILL_STROKE_CLIP(6),
    NEITHER_CLIP(7);

    private final int value;

    public static RenderingMode getRenderingMode(int value) {
        if (value < 0 || value > 7) {
            return null;
        }
        return RenderingMode.values()[value];
    }

    private RenderingMode(int value) {
        this.value = value;
    }

    public boolean isFill() {
        return this == FILL || this == FILL_STROKE || this == FILL_CLIP || this == FILL_STROKE_CLIP;
    }

    public boolean isStroke() {
        return this == STROKE || this == FILL_STROKE || this == STROKE_CLIP || this == FILL_STROKE_CLIP;
    }

    public int getValue() {
        return this.value;
    }
}

