/**
 * This file is part of veraPDF wcag algorithms, a module of the veraPDF project.
 * Copyright (c) 2015, veraPDF Consortium <info@verapdf.org>
 * All rights reserved.
 *
 * veraPDF wcag algorithms is free software: you can redistribute it and/or modify
 * it under the terms of either:
 *
 * The GNU General public license GPLv3+.
 * You should have received a copy of the GNU General Public License
 * along with veraPDF wcag algorithms as the LICENSE.GPL file in the root of the source
 * tree.  If not, see http://www.gnu.org/licenses/ or
 * https://www.gnu.org/licenses/gpl-3.0.en.html.
 *
 * The Mozilla Public License MPLv2+.
 * You should have received a copy of the Mozilla Public License along with
 * veraPDF wcag algorithms as the LICENSE.MPL file in the root of the source tree.
 * If a copy of the MPL was not distributed with this file, you can obtain one at
 * http://mozilla.org/MPL/2.0/.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms;

import org.verapdf.wcag.algorithms.entities.IDocument;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableBordersCollection;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.*;

import java.util.function.Consumer;

public class AccumulatedNodeSemanticChecker implements ISemanticsChecker {

	@Override
	public void checkSemanticDocument(IDocument document) {
		ITree tree = document.getTree();

		LinesPreprocessingConsumer linesPreprocessingConsumer = new LinesPreprocessingConsumer(document);
		linesPreprocessingConsumer.findTableBorders();

		Consumer<INode> semanticDocumentValidator = new SemanticDocumentPreprocessingConsumer(document,
				linesPreprocessingConsumer.getLinesCollection());
		tree.forEach(semanticDocumentValidator);

		Table.updateTableCounter();

		TableBordersCollection tableBordersCollection = new TableBordersCollection(linesPreprocessingConsumer.getTableBorders());

		AccumulatedNodeConsumer semanticDetectionValidator = new AccumulatedNodeConsumer(tableBordersCollection);
		tree.forEach(semanticDetectionValidator);

		TableBorderConsumer tableBorderConsumer = new TableBorderConsumer(tableBordersCollection, null);
		tableBorderConsumer.recognizeTables(tree);

//		ClusterTableConsumer tableFinder = new ClusterTableConsumer(tableBordersCollection,
//				semanticDetectionValidator.getAccumulatedNodeMapper());
//		tree.forEach(tableFinder);

		SemanticDocumentPostprocessingConsumer documentPostprocessingConsumer =
				new SemanticDocumentPostprocessingConsumer(semanticDetectionValidator.getAccumulatedNodeMapper());
		documentPostprocessingConsumer.checkForTitle(tree);
	}
}
