/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.content;

import java.util.Objects;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;

public abstract class TextInfoChunk
extends InfoChunk {
    protected double fontSize = 0.0;
    protected double baseLine = Double.MAX_VALUE;

    public TextInfoChunk() {
    }

    public TextInfoChunk(BoundingBox bbox) {
        super(bbox);
    }

    public TextInfoChunk(BoundingBox bbox, double fontSize, double baseLine) {
        super(bbox);
        this.fontSize = fontSize;
        this.baseLine = baseLine;
    }

    public void setFontSize(double fontSize) {
        this.fontSize = fontSize;
    }

    public double getFontSize() {
        return this.fontSize;
    }

    public void setBaseLine(double baseLine) {
        this.baseLine = baseLine;
    }

    public double getBaseLine() {
        return this.baseLine;
    }

    protected void add(TextInfoChunk chunk) {
        if (this.fontSize < chunk.getFontSize()) {
            this.fontSize = chunk.getFontSize();
        }
        if (chunk.getBaseLine() < this.baseLine) {
            this.baseLine = chunk.getBaseLine();
        }
        this.unionBoundingBox(chunk.getBoundingBox());
    }

    @Override
    public boolean equals(Object o) {
        if (!super.equals(o)) {
            return false;
        }
        TextInfoChunk that = (TextInfoChunk)o;
        return Double.compare(that.fontSize, this.fontSize) == 0 && Double.compare(that.baseLine, this.baseLine) == 0;
    }

    @Override
    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + Objects.hash(this.fontSize, this.baseLine);
        return result;
    }
}

