/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.lists;

import org.verapdf.wcag.algorithms.entities.content.TextInfoChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.lists.ListBody;
import org.verapdf.wcag.algorithms.entities.lists.ListLabel;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;

public class ListItem
extends TextInfoChunk {
    private final ListLabel label;
    private final ListBody body;
    private SemanticType semanticType = SemanticType.LIST_ITEM;

    public ListItem(TableRow tableRow) {
        super(tableRow.getBoundingBox(), tableRow.getFontSize(), tableRow.getBaseLine());
        this.label = new ListLabel(tableRow.getCells().get(0));
        this.body = new ListBody(tableRow.getCells().get(1));
    }

    public void add(TableRow tableRow) {
        this.label.add(tableRow.getCells().get(0));
        this.body.add(tableRow.getCells().get(1));
        super.add(tableRow);
    }

    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public ListLabel getLabel() {
        return this.label;
    }

    public ListBody getBody() {
        return this.body;
    }
}

