/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.content.InfoChunk;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableCluster;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TableUtils;

public class Table
extends InfoChunk {
    private static Long tableCounter = 0L;
    private static final double ROW_GAP_DIFF_TOLERANCE = 0.35;
    private static final double ROW_WIDTH_FACTOR = 1.2;
    private static final double INTER_TABLE_GAP_FACTOR = 1.8;
    private final Long id;
    private List<TableRow> rows;
    private Double validationScore;
    private TableBorder tableBorder;
    private final List<INode> restNodes;

    public Table(List<TableCluster> headers) {
        Long l = tableCounter;
        tableCounter = tableCounter + 1L;
        Long l2 = tableCounter;
        this.id = l;
        this.validationScore = null;
        this.rows = new ArrayList<TableRow>();
        TableRow headersRow = new TableRow(SemanticType.TABLE_HEADERS);
        for (TableCluster header : headers) {
            headersRow.add(new TableCell(header, SemanticType.TABLE_HEADER));
            this.getBoundingBox().union(header.getBoundingBox());
        }
        this.rows.add(headersRow);
        this.restNodes = new ArrayList<INode>();
    }

    public int numberOfRows() {
        return this.rows.size();
    }

    public int numberOfColumns() {
        if (this.rows.isEmpty()) {
            return 0;
        }
        return this.rows.get(0).getCells().size();
    }

    public List<TableRow> getRows() {
        return this.rows;
    }

    public Long getId() {
        return this.id;
    }

    public void add(TableRow row) {
        this.rows.add(row);
        this.getBoundingBox().union(row.getBoundingBox());
    }

    public void updateTableRows() {
        if (this.rows.size() < 2) {
            return;
        }
        this.rows = this.pickCompactRows(this.rows);
        int numColumns = this.numberOfColumns();
        ArrayList<Double> maxRowGaps = new ArrayList<Double>(numColumns);
        for (int col = 0; col < numColumns; ++col) {
            double maxGap = 0.0;
            double minGap = Double.MAX_VALUE;
            List<TableCell> firstRowCells = this.rows.get(1).getCells();
            TableTokenRow currentTokenRow = col < firstRowCells.size() ? firstRowCells.get(col).getLastTokenRow() : null;
            for (int i = 2; i < this.rows.size(); ++i) {
                List<TableCell> rowCells = this.rows.get(i).getCells();
                if (col >= rowCells.size() || rowCells.get(col).isEmpty()) continue;
                if (currentTokenRow != null) {
                    double gap = TableUtils.getRowGapFactor(currentTokenRow, rowCells.get(col).getFirstTokenRow());
                    if (gap < minGap) {
                        minGap = gap;
                    }
                    if (maxGap < gap) {
                        maxGap = gap;
                    }
                }
                currentTokenRow = rowCells.get(col).getLastTokenRow();
            }
            maxRowGaps.add(maxGap > (minGap += 0.35) ? minGap : 0.0);
        }
        ArrayList<TableRow> result = new ArrayList<TableRow>();
        result.add(this.rows.get(0));
        result.add(this.rows.get(1));
        TableRow currentRow = this.rows.get(1);
        for (int i = 2; i < this.rows.size(); ++i) {
            if (this.areSeparateRows(currentRow, this.rows.get(i), maxRowGaps)) {
                currentRow = this.rows.get(i);
                result.add(currentRow);
                continue;
            }
            currentRow.merge(this.rows.get(i));
        }
        this.rows = result;
    }

    private boolean areSeparateRows(TableRow row, TableRow nextRow, List<Double> maxRowGaps) {
        boolean disconnected = true;
        int numColumns = Math.min(Math.min(row.getCells().size(), nextRow.getCells().size()), maxRowGaps.size());
        for (int col = 0; col < numColumns; ++col) {
            TableTokenRow tokenRow = row.getCells().get(col).getLastTokenRow();
            TableTokenRow nextTokenRow = nextRow.getCells().get(col).getFirstTokenRow();
            if (tokenRow == null || nextTokenRow == null) continue;
            double gap = TableUtils.getRowGapFactor(tokenRow, nextTokenRow);
            if (gap > maxRowGaps.get(col)) {
                return true;
            }
            disconnected = false;
        }
        return disconnected;
    }

    private List<TableRow> pickCompactRows(List<TableRow> allRows) {
        if (allRows.size() < 3) {
            return allRows;
        }
        double gapAfterHeaders = this.gapBetweenRows(allRows.get(0), allRows.get(1));
        gapAfterHeaders = 1.8 * gapAfterHeaders + 0.35;
        Double gapBetweenBodyRows = null;
        for (int i = 2; i < allRows.size(); ++i) {
            TableRow prevRow = allRows.get(i - 1);
            TableRow currentRow = allRows.get(i);
            double gap = Math.max(this.weightedGapBetweenRows(prevRow, currentRow), 0.0);
            if (gapBetweenBodyRows == null) {
                gapBetweenBodyRows = gap < gapAfterHeaders ? Double.valueOf(0.5 * (gapAfterHeaders + 1.8 * gap + 0.35)) : Double.valueOf(0.0);
            }
            if (!(gap > gapBetweenBodyRows)) continue;
            this.extractRestNodes(allRows.subList(i, allRows.size()));
            return allRows.subList(0, i);
        }
        return allRows;
    }

    private void extractRestNodes(List<TableRow> restRows) {
        HashSet<INode> nodeSet = new HashSet<INode>();
        for (TableRow row : restRows) {
            for (TableCell cell : row.getCells()) {
                for (TableTokenRow tableTokenRow : cell.getContent()) {
                    for (TextChunk chunk : tableTokenRow.getTextChunks()) {
                        INode node;
                        if (!(chunk instanceof TableToken) || nodeSet.contains(node = ((TableToken)chunk).getNode())) continue;
                        this.restNodes.add(node);
                        nodeSet.add(node);
                    }
                }
            }
        }
    }

    private double gapBetweenRows(TableRow firstRow, TableRow secondRow) {
        double minGap = Double.MAX_VALUE;
        int numColumns = Math.min(firstRow.getCells().size(), secondRow.getCells().size());
        for (int col = 0; col < numColumns; ++col) {
            double gap;
            TableTokenRow tokenRow = firstRow.getCells().get(col).getLastTokenRow();
            TableTokenRow nextTokenRow = secondRow.getCells().get(col).getFirstTokenRow();
            if (tokenRow == null || nextTokenRow == null || !((gap = TableUtils.getRowGapFactor(tokenRow, nextTokenRow)) < minGap)) continue;
            minGap = gap;
        }
        return minGap;
    }

    private double weightedGapBetweenRows(TableRow firstRow, TableRow secondRow) {
        double minGap = Double.MAX_VALUE;
        double alignmentFactor = 1.0;
        double maxStyleFactor = 1.0;
        int numColumns = Math.min(firstRow.getCells().size(), secondRow.getCells().size());
        for (int col = 0; col < numColumns; ++col) {
            TableCell firstCell = firstRow.getCells().get(col);
            TableCell secondCell = secondRow.getCells().get(col);
            TableTokenRow tokenRow = firstCell.getLastTokenRow();
            TableTokenRow nextTokenRow = secondCell.getFirstTokenRow();
            if (tokenRow == null || nextTokenRow == null) continue;
            double gap = TableUtils.getRowGapFactor(tokenRow, nextTokenRow);
            if (gap < minGap) {
                minGap = gap;
            }
            alignmentFactor += TableUtils.minDeviation(firstCell, secondCell);
            TextChunk firstChunk = tokenRow.getFirstTextChunk();
            TextChunk secondChunk = nextTokenRow.getFirstTextChunk();
            if (firstChunk.getValue().isEmpty()) continue;
            double styleFactor = firstChunk.getFontName() != null && firstChunk.getFontName().equals(secondChunk.getFontName()) ? 1.0 : 1.2;
            styleFactor *= Math.max(firstCell.getFontSize(), secondCell.getFontSize()) / Math.min(firstCell.getFontSize(), secondCell.getFontSize());
            styleFactor *= Math.max(firstChunk.getFontWeight(), secondChunk.getFontWeight()) / Math.min(firstChunk.getFontWeight(), secondChunk.getFontWeight());
            if (!(maxStyleFactor < (styleFactor *= Math.max(firstChunk.getItalicAngle(), secondChunk.getItalicAngle()) / Math.min(firstChunk.getItalicAngle(), secondChunk.getItalicAngle())))) continue;
            maxStyleFactor = styleFactor;
        }
        return minGap * alignmentFactor * maxStyleFactor;
    }

    public double getValidationScore() {
        if (this.validationScore == null) {
            this.validate();
        }
        return this.validationScore;
    }

    public void validate() {
        if (this.rows.size() < 2 || this.numberOfColumns() < 2) {
            this.validationScore = 0.0;
            return;
        }
        double maxIntersection = 0.0;
        for (int i = 1; i < this.rows.size(); ++i) {
            double prevRowBaseLine = this.rows.get(i - 1).getBaseLine();
            TableRow row = this.rows.get(i);
            for (TableCell cell : row.getCells()) {
                TableTokenRow firstTokenRow = cell.getFirstTokenRow();
                if (firstTokenRow == null) continue;
                double rowWidth = firstTokenRow.getFontSize() * 1.2;
                double intersection = 1.0 - (prevRowBaseLine - firstTokenRow.getBaseLine()) / rowWidth;
                if (!(maxIntersection < intersection)) continue;
                maxIntersection = intersection;
            }
        }
        this.validationScore = Math.max(0.0, 1.0 - maxIntersection);
    }

    public List<INode> getRestNodes() {
        return this.restNodes;
    }

    public static void updateTableCounter() {
        tableCounter = 0L;
    }

    public static Long getNextTableListId() {
        Long l = tableCounter;
        Long l2 = tableCounter = Long.valueOf(tableCounter + 1L);
        return l;
    }

    public TableBorder getTableBorder() {
        return this.tableBorder;
    }

    public void setTableBorder(TableBorder tableBorder) {
        this.tableBorder = tableBorder;
        if (tableBorder != null) {
            this.setBoundingBox(tableBorder.getBoundingBox());
        }
    }
}

