/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.entities.tables.tableBorders;

import java.util.LinkedList;
import java.util.List;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.geometry.BoundingBox;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;

public class TableBorderCell {
    public int rowNumber;
    public int colNumber;
    public int rowSpan;
    public int colSpan;
    private BoundingBox boundingBox;
    private final List<TableToken> content;
    private SemanticType semanticType;
    private INode node;

    public TableBorderCell(int rowNumber, int colNumber, int rowSpan, int colSpan) {
        this.rowNumber = rowNumber;
        this.colNumber = colNumber;
        this.rowSpan = rowSpan;
        this.colSpan = colSpan;
        this.content = new LinkedList<TableToken>();
    }

    public void setBoundingBox(BoundingBox boundingBox) {
        this.boundingBox = boundingBox;
    }

    public double getTopY() {
        return this.boundingBox.getTopY();
    }

    public double getBottomY() {
        return this.boundingBox.getBottomY();
    }

    public double getLeftX() {
        return this.boundingBox.getLeftX();
    }

    public double getRightX() {
        return this.boundingBox.getRightX();
    }

    public double getWidth() {
        return this.boundingBox.getWidth();
    }

    public double getHeight() {
        return this.boundingBox.getHeight();
    }

    public BoundingBox getBoundingBox() {
        return this.boundingBox;
    }

    public void addContent(TableToken token) {
        this.content.add(token);
    }

    public List<TableToken> getContent() {
        return this.content;
    }

    public SemanticType getSemanticType() {
        return this.semanticType;
    }

    public void setSemanticType(SemanticType semanticType) {
        this.semanticType = semanticType;
    }

    public INode getNode() {
        return this.node;
    }

    public void setNode(INode node) {
        this.node = node;
    }
}

