/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Stack;
import java.util.function.Consumer;
import java.util.logging.Logger;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.NodeInfo;
import org.verapdf.wcag.algorithms.entities.SemanticCaption;
import org.verapdf.wcag.algorithms.entities.SemanticImageNode;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.lists.ListElement;
import org.verapdf.wcag.algorithms.entities.lists.ListItem;
import org.verapdf.wcag.algorithms.entities.lists.PDFList;
import org.verapdf.wcag.algorithms.entities.maps.AccumulatedNodeMapper;
import org.verapdf.wcag.algorithms.entities.tables.Table;
import org.verapdf.wcag.algorithms.entities.tables.TableBordersCollection;
import org.verapdf.wcag.algorithms.entities.tables.TableCell;
import org.verapdf.wcag.algorithms.entities.tables.TableRow;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.TableTokenRow;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.semanticalgorithms.consumers.AccumulatedNodeConsumer;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableRecognitionArea;
import org.verapdf.wcag.algorithms.semanticalgorithms.tables.TableRecognizer;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.ListUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.NodeUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TableUtils;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TextChunkUtils;

public class ClusterTableConsumer
implements Consumer<INode> {
    private static final Logger LOGGER = Logger.getLogger(AccumulatedNodeConsumer.class.getCanonicalName());
    private final AccumulatedNodeMapper accumulatedNodeMapper;
    private TableRecognitionArea recognitionArea;
    private final List<Table> tables = new ArrayList<Table>();
    private final List<PDFList> lists = new ArrayList<PDFList>();
    private final TableBordersCollection tableBorders;

    public ClusterTableConsumer(TableBordersCollection tableBorders, AccumulatedNodeMapper accumulatedNodeMapper) {
        this.init();
        this.tableBorders = tableBorders;
        this.accumulatedNodeMapper = accumulatedNodeMapper;
    }

    private void init() {
        this.recognitionArea = new TableRecognitionArea();
    }

    public List<Table> getTables() {
        return this.tables;
    }

    public List<PDFList> getLists() {
        return this.lists;
    }

    @Override
    public void accept(INode node) {
        if (node.getChildren().isEmpty()) {
            if (node instanceof SemanticTextNode) {
                SemanticTextNode textNode = (SemanticTextNode)node;
                for (TextLine line : textNode.getLines()) {
                    for (TextChunk chunk : line.getTextChunks()) {
                        if (TextChunkUtils.isWhiteSpaceChunk(chunk)) continue;
                        TableToken token = new TableToken(chunk, node);
                        this.accept(token);
                    }
                }
            } else if (node instanceof SemanticImageNode) {
                SemanticImageNode imageNode = (SemanticImageNode)node;
                TableToken token = new TableToken(imageNode.getImage(), (INode)imageNode);
                this.accept(token);
            }
        }
        if (node.isRoot()) {
            if (this.recognitionArea.isValid()) {
                ArrayList<INode> restNodes = new ArrayList<INode>(this.recognize());
                this.init();
                restNodes.add(node);
                for (INode restNode : restNodes) {
                    this.accept(restNode);
                }
            }
            this.updateTreeWithRecognizedTables(node);
            this.updateTreeWithRecognizedLists(node);
        }
    }

    private void findTableBorder() {
        TableBorder tableBorder = this.tableBorders.getTableBorder(this.recognitionArea.getBoundingBox());
        if (tableBorder != null) {
            this.recognitionArea.setTableBorder(tableBorder);
        }
    }

    @Override
    private void accept(TableToken token) {
        if (this.recognitionArea.addTokenToRecognitionArea(token) && this.recognitionArea.getTableBorder() == null) {
            this.findTableBorder();
        }
        if (this.recognitionArea.isComplete()) {
            ArrayList<INode> restNodes = new ArrayList<INode>();
            if (this.recognitionArea.isValid()) {
                restNodes.addAll(this.recognize());
            }
            this.init();
            restNodes.add(token.getNode());
            for (INode restNode : restNodes) {
                this.accept(restNode);
            }
        }
    }

    private List<INode> recognize() {
        TableRecognizer recognizer = new TableRecognizer(this.recognitionArea);
        recognizer.recognize();
        Table recognizedTable = recognizer.getTable();
        if (recognizedTable != null) {
            if (recognizedTable.getTableBorder() == null && ListUtils.isList(recognizedTable)) {
                this.lists.add(new PDFList(recognizedTable));
            } else {
                this.tables.add(recognizedTable);
            }
            return recognizedTable.getRestNodes();
        }
        return new ArrayList<INode>();
    }

    private void updateTreeWithRecognizedTables(INode root) {
        this.initTreeNodeInfo(root);
        for (Table table : this.tables) {
            INode tableRoot = this.updateTreeWithRecognizedTable(table, root);
            if (tableRoot == null) continue;
            if ((TableUtils.isTableNode(tableRoot) || ListUtils.isListNode(tableRoot) && table.getTableBorder() == null) && tableRoot.getRecognizedStructureId() != table.getId()) {
                tableRoot.setRecognizedStructureId(null);
                continue;
            }
            tableRoot.setRecognizedStructureId(table.getId());
            tableRoot.setSemanticType(SemanticType.TABLE);
            tableRoot.setCorrectSemanticScore(1.0);
            this.detectTableCaptions(table, tableRoot);
        }
    }

    private void detectTableCaptions(Table table, INode tableRoot) {
        this.detectTableCaption(table, tableRoot.getPreviousNeighbor());
        this.detectTableCaption(table, tableRoot.getNextNeighbor());
    }

    private void detectTableCaption(Table table, INode node) {
        if (node == null) {
            return;
        }
        if (node.getSemanticType() == SemanticType.HEADING || node.getSemanticType() == SemanticType.NUMBER_HEADING) {
            return;
        }
        INode accumulatedNode = this.accumulatedNodeMapper.get(node);
        double captionProbability = NodeUtils.tableCaptionProbability(accumulatedNode, table);
        if (captionProbability >= 0.75) {
            this.accumulatedNodeMapper.updateNode(node, new SemanticCaption((SemanticTextNode)accumulatedNode), captionProbability * node.getCorrectSemanticScore(), SemanticType.CAPTION);
        }
    }

    private INode updateTreeWithRecognizedTable(Table table, INode root) {
        HashMap rowNodes = new HashMap();
        rowNodes.put(SemanticType.TABLE_HEADERS, new HashSet());
        rowNodes.put(SemanticType.TABLE_BODY, new HashSet());
        for (int i = 0; i < table.getRows().size(); ++i) {
            TableRow row = table.getRows().get(i);
            INode rowNode = this.updateTreeWithRecognizedTableRow(table, row, i == 0 ? null : table.getRows().get(i - 1));
            if (rowNode == null) continue;
            if ((ListUtils.isListNode(rowNode) && table.getTableBorder() == null || TableUtils.isTableNode(rowNode)) && rowNode.getRecognizedStructureId() != table.getId()) {
                rowNode.setRecognizedStructureId(null);
            } else {
                rowNode.setRecognizedStructureId(table.getId());
                rowNode.setSemanticType(SemanticType.TABLE_ROW);
                rowNode.setCorrectSemanticScore(1.0);
            }
            SemanticType semanticType = row.getSemanticType();
            Set nodes = (Set)rowNodes.get((Object)semanticType);
            if (nodes == null) continue;
            nodes.add(rowNode);
        }
        Set headersNodes = (Set)rowNodes.get((Object)SemanticType.TABLE_HEADERS);
        if (headersNodes.size() == 1 && headersNodes.equals(rowNodes.get((Object)SemanticType.TABLE_BODY))) {
            return (INode)headersNodes.iterator().next();
        }
        HashSet<INode> localRoots = new HashSet<INode>();
        for (Map.Entry entry : rowNodes.entrySet()) {
            SemanticType type = (SemanticType)((Object)entry.getKey());
            Set rows = (Set)entry.getValue();
            INode localRoot = this.findLocalRoot(rows);
            if (localRoot == null) continue;
            if ((TableUtils.isTableNode(localRoot) || ListUtils.isListNode(localRoot) && table.getTableBorder() == null) && localRoot.getRecognizedStructureId() != table.getId()) {
                localRoot.setRecognizedStructureId(null);
            } else {
                localRoot.setRecognizedStructureId(table.getId());
                localRoot.setSemanticType(type);
                localRoot.setCorrectSemanticScore(1.0);
            }
            localRoots.add(localRoot);
        }
        if (localRoots.isEmpty()) {
            return null;
        }
        if (localRoots.size() == 1) {
            return (INode)localRoots.iterator().next();
        }
        List localRootsList = localRoots.stream().collect(Collectors.toList());
        if (((INode)localRootsList.get((int)0)).getNodeInfo().depth < ((INode)localRootsList.get((int)1)).getNodeInfo().depth && this.isAncestorFor((INode)localRootsList.get(0), (INode)localRootsList.get(1))) {
            return (INode)localRootsList.get(0);
        }
        if (((INode)localRootsList.get((int)1)).getNodeInfo().depth < ((INode)localRootsList.get((int)0)).getNodeInfo().depth && this.isAncestorFor((INode)localRootsList.get(1), (INode)localRootsList.get(0))) {
            return (INode)localRootsList.get(1);
        }
        return this.findLocalRoot(localRoots);
    }

    private INode updateTreeWithRecognizedTableRow(Table table, TableRow row, TableRow previousRow) {
        Long id = table.getId();
        HashMap<INode, Integer> cellNodes = new HashMap<INode, Integer>();
        for (int i = 0; i < row.getCells().size(); ++i) {
            INode cellNode = this.updateTreeWithRecognizedCell(row.getCells().get(i));
            if (cellNode == null) continue;
            cellNodes.put(cellNode, i);
        }
        INode rowNode = this.findLocalRoot(cellNodes.keySet());
        for (Map.Entry entry : cellNodes.entrySet()) {
            INode cellNode = (INode)entry.getKey();
            while (cellNode.getParent() != null && cellNode.getParent() != rowNode && cellNode.getParent().getChildren().size() == 1) {
                cellNode = cellNode.getParent();
            }
            if ((ListUtils.isListNode(cellNode) && table.getTableBorder() == null || TableUtils.isTableNode(cellNode)) && cellNode.getRecognizedStructureId() != id) {
                cellNode.setRecognizedStructureId(null);
                continue;
            }
            cellNode.setRecognizedStructureId(id);
            if (this.isHeaderCell(cellNode, (Integer)entry.getValue(), (Integer)entry.getValue() == 0 ? null : row.getCells().get((Integer)entry.getValue() - 1), previousRow)) {
                cellNode.setSemanticType(SemanticType.TABLE_HEADER);
                row.getCells().get((Integer)entry.getValue()).setSemanticType(SemanticType.TABLE_HEADER);
            } else {
                cellNode.setSemanticType(SemanticType.TABLE_CELL);
                row.getCells().get((Integer)entry.getValue()).setSemanticType(SemanticType.TABLE_CELL);
            }
            cellNode.setCorrectSemanticScore(1.0);
        }
        return rowNode;
    }

    private boolean isHeaderCell(INode cellNode, Integer columnNumber, TableCell previousCell, TableRow previousRow) {
        if (cellNode.getInitialSemanticType() != SemanticType.TABLE_HEADER) {
            return false;
        }
        if (previousCell == null || previousRow == null || previousCell.getSemanticType() == SemanticType.TABLE_HEADER) {
            return true;
        }
        return columnNumber < previousRow.getCells().size() && previousRow.getCells().get(columnNumber).getSemanticType() == SemanticType.TABLE_HEADER;
    }

    private INode updateTreeWithRecognizedCell(TableCell cell) {
        HashSet<INode> tableLeafNodes = new HashSet<INode>();
        for (TableTokenRow tokenRow : cell.getContent()) {
            for (TextChunk chunk : tokenRow.getTextChunks()) {
                TableToken token;
                if (!(chunk instanceof TableToken) || (token = (TableToken)chunk).getNode() == null) continue;
                tableLeafNodes.add(token.getNode());
            }
        }
        return this.findLocalRoot(tableLeafNodes);
    }

    private void updateTreeWithRecognizedLists(INode root) {
        this.initTreeNodeInfo(root);
        for (PDFList list : this.lists) {
            INode listRoot = this.updateTreeWithRecognizedList(list);
            if (listRoot == null) continue;
            if ((ListUtils.isListNode(listRoot) || TableUtils.isTableNode(listRoot)) && listRoot.getRecognizedStructureId() != list.getId()) {
                listRoot.setRecognizedStructureId(null);
                continue;
            }
            listRoot.setRecognizedStructureId(list.getId());
            listRoot.setSemanticType(SemanticType.LIST);
            listRoot.setCorrectSemanticScore(1.0);
        }
    }

    private INode updateTreeWithRecognizedList(PDFList list) {
        HashSet<INode> nodes = new HashSet<INode>();
        for (ListItem item : list.getListItems()) {
            INode itemNode = this.updateTreeWithRecognizedListItem(item, list.getId());
            if (itemNode == null) continue;
            if ((ListUtils.isListNode(itemNode) || TableUtils.isTableNode(itemNode)) && itemNode.getRecognizedStructureId() != list.getId()) {
                itemNode.setRecognizedStructureId(null);
            } else {
                itemNode.setRecognizedStructureId(list.getId());
                itemNode.setSemanticType(SemanticType.LIST_ITEM);
                itemNode.setCorrectSemanticScore(1.0);
            }
            nodes.add(itemNode);
        }
        if (nodes.size() == 1) {
            return (INode)nodes.iterator().next();
        }
        return this.findLocalRoot(nodes);
    }

    private INode updateTreeWithRecognizedListItem(ListItem item, Long id) {
        INode bodyNode;
        HashMap<INode, SemanticType> elementsNodes = new HashMap<INode, SemanticType>();
        INode labelNode = this.updateTreeWithRecognizedListElement(item.getLabel());
        if (labelNode != null) {
            elementsNodes.put(labelNode, item.getLabel().getSemanticType());
        }
        if ((bodyNode = this.updateTreeWithRecognizedListElement(item.getBody())) != null) {
            elementsNodes.put(bodyNode, item.getBody().getSemanticType());
        }
        if (labelNode != null && bodyNode != null && labelNode.equals(bodyNode)) {
            return labelNode;
        }
        INode itemNode = this.findLocalRoot(elementsNodes.keySet());
        for (Map.Entry entry : elementsNodes.entrySet()) {
            INode elementNode = (INode)entry.getKey();
            while (elementNode.getParent() != null && elementNode.getParent() != itemNode && elementNode.getParent().getChildren().size() == 1) {
                elementNode = elementNode.getParent();
            }
            if ((ListUtils.isListNode(elementNode) || TableUtils.isTableNode(elementNode)) && elementNode.getRecognizedStructureId() != id) {
                elementNode.setRecognizedStructureId(null);
                continue;
            }
            elementNode.setRecognizedStructureId(id);
            elementNode.setSemanticType((SemanticType)((Object)entry.getValue()));
            elementNode.setCorrectSemanticScore(1.0);
        }
        return itemNode;
    }

    private INode updateTreeWithRecognizedListElement(ListElement listElement) {
        HashSet<INode> tableLeafNodes = new HashSet<INode>();
        for (TableTokenRow tokenRow : listElement.getContent()) {
            for (TextChunk chunk : tokenRow.getTextChunks()) {
                TableToken token;
                if (!(chunk instanceof TableToken) || (token = (TableToken)chunk).getNode() == null) continue;
                tableLeafNodes.add(token.getNode());
            }
        }
        return this.findLocalRoot(tableLeafNodes);
    }

    private INode findLocalRoot(Set<INode> nodes) {
        INode localRoot = null;
        block0: for (INode node : nodes) {
            if (node.isRoot()) {
                localRoot = node;
                break;
            }
            if (localRoot == null) {
                localRoot = node.getParent();
            }
            while (!node.isRoot()) {
                INode parent = node.getParent();
                NodeInfo parentInfo = parent.getNodeInfo();
                ++parentInfo.counter;
                if (parentInfo.counter > 1) {
                    if (parentInfo.depth >= localRoot.getNodeInfo().depth) continue block0;
                    localRoot = parent;
                    continue block0;
                }
                node = parent;
            }
        }
        this.initTreeCounters(localRoot);
        return localRoot;
    }

    private boolean isAncestorFor(INode first, INode second) {
        while (!second.isRoot()) {
            if ((second = second.getParent()) != first) continue;
            return true;
        }
        return false;
    }

    private void initTreeCounters(INode root) {
        if (root == null) {
            return;
        }
        Stack<INode> nodeStack = new Stack<INode>();
        nodeStack.push(root);
        while (!nodeStack.isEmpty()) {
            INode node = (INode)nodeStack.pop();
            NodeInfo nodeInfo = node.getNodeInfo();
            nodeInfo.counter = 0;
            for (INode child : node.getChildren()) {
                nodeStack.push(child);
            }
        }
        while (!root.isRoot()) {
            root = root.getParent();
            root.getNodeInfo().counter = 0;
        }
    }

    private void initTreeNodeInfo(INode root) {
        Stack<INode> nodeStack = new Stack<INode>();
        nodeStack.push(root);
        while (!nodeStack.isEmpty()) {
            INode node = (INode)nodeStack.pop();
            NodeInfo nodeInfo = node.getNodeInfo();
            nodeInfo.depth = node.isRoot() ? 0 : node.getParent().getNodeInfo().depth + 1;
            nodeInfo.counter = 0;
            for (INode child : node.getChildren()) {
                nodeStack.push(child);
            }
        }
    }
}

