/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.maps.AccumulatedNodeMapper;

public class SemanticDocumentPostprocessingConsumer {
    private final AccumulatedNodeMapper accumulatedNodeMapper;

    public SemanticDocumentPostprocessingConsumer(AccumulatedNodeMapper accumulatedNodeMapper) {
        this.accumulatedNodeMapper = accumulatedNodeMapper;
    }

    public void checkForTitle(ITree tree) {
        for (INode node : tree) {
            if (this.checkNode(node)) break;
        }
    }

    private boolean checkNode(INode node) {
        if (this.isTextNode(node)) {
            if (this.isTitle(node)) {
                node.setSemanticType(SemanticType.TITLE);
                return true;
            }
            for (INode parent = node.getParent(); parent != null && this.accumulatedNodeMapper.get(parent) instanceof SemanticTextNode; parent = parent.getParent()) {
                if (!this.isTitle(parent)) continue;
                parent.setSemanticType(SemanticType.TITLE);
                break;
            }
            return true;
        }
        return false;
    }

    private boolean isTextNode(INode node) {
        INode accumulatedNode = this.accumulatedNodeMapper.get(node);
        return accumulatedNode instanceof SemanticTextNode && !((SemanticTextNode)accumulatedNode).isSpaceNode() && !node.getChildren().isEmpty();
    }

    private boolean isTitle(INode node) {
        return SemanticType.HEADING.equals((Object)node.getSemanticType()) && !SemanticType.HEADING.equals((Object)node.getInitialSemanticType()) || SemanticType.NUMBER_HEADING.equals((Object)node.getSemanticType()) && !SemanticType.NUMBER_HEADING.equals((Object)node.getInitialSemanticType());
    }
}

