/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.consumers;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.stream.Collectors;
import org.verapdf.wcag.algorithms.entities.INode;
import org.verapdf.wcag.algorithms.entities.ITree;
import org.verapdf.wcag.algorithms.entities.SemanticImageNode;
import org.verapdf.wcag.algorithms.entities.SemanticTextNode;
import org.verapdf.wcag.algorithms.entities.content.TextChunk;
import org.verapdf.wcag.algorithms.entities.content.TextLine;
import org.verapdf.wcag.algorithms.entities.enums.SemanticType;
import org.verapdf.wcag.algorithms.entities.maps.AccumulatedNodeMapper;
import org.verapdf.wcag.algorithms.entities.tables.TableBordersCollection;
import org.verapdf.wcag.algorithms.entities.tables.TableToken;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorder;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderCell;
import org.verapdf.wcag.algorithms.entities.tables.tableBorders.TableBorderRow;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.TableUtils;

public class TableBorderConsumer {
    private final AccumulatedNodeMapper accumulatedNodeMapper;
    private final TableBordersCollection tableBorders;

    public TableBorderConsumer(TableBordersCollection tableBorders, AccumulatedNodeMapper accumulatedNodeMapper) {
        this.tableBorders = tableBorders;
        this.accumulatedNodeMapper = accumulatedNodeMapper;
    }

    public void recognizeTables(ITree tree) {
        for (INode node : tree) {
            if (!node.getChildren().isEmpty()) continue;
            if (node instanceof SemanticTextNode) {
                SemanticTextNode textNode = (SemanticTextNode)node;
                for (TextLine line : textNode.getLines()) {
                    for (TextChunk chunk : line.getTextChunks()) {
                        this.add(new TableToken(chunk, node));
                    }
                }
                continue;
            }
            if (!(node instanceof SemanticImageNode)) continue;
            SemanticImageNode imageNode = (SemanticImageNode)node;
            this.add(new TableToken(imageNode.getImage(), (INode)imageNode));
        }
        this.updateTreeWithRecognizedTables();
    }

    private void add(TableToken token) {
        TableBorderCell tableBorderCell;
        TableBorder tableBorder = this.tableBorders.getTableBorder(token.getBoundingBox());
        if (tableBorder != null && (tableBorderCell = tableBorder.getTableBorderCell(token.getBoundingBox())) != null) {
            tableBorderCell.addContent(token);
        }
    }

    private void updateTreeWithRecognizedTables() {
        for (SortedSet<TableBorder> tables : this.tableBorders.getTableBorders()) {
            for (TableBorder table : tables) {
                INode tableNode = this.getTableNode(table);
                if (tableNode == null) continue;
                TableBorderConsumer.setType(tableNode, SemanticType.TABLE, table.getId());
                Integer depth = Arrays.stream(table.getRows()).map(TableBorderRow::getNode).filter(Objects::nonNull).map(INode::getDepth).min(Integer::compare).orElse(null);
                Set<INode> rowNodes = Arrays.stream(table.getRows()).map(TableBorderRow::getNode).collect(Collectors.toSet());
                if (depth == null) continue;
                if (tableNode.getDepth() < depth - 1) {
                    TableBorderConsumer.updateTreeWithRecognizedTableRowsGroups(table, tableNode, rowNodes);
                } else {
                    TableBorderConsumer.setTypesForEmptyRowNodes(table, tableNode.getChildren());
                }
                TableBorderConsumer.updateTreeWithRecognizedTableRows(table, depth);
            }
        }
    }

    private static void setTypesForEmptyRowNodes(TableBorder table, List<INode> rowNodes) {
        if (rowNodes.size() == table.getNumberOfRows()) {
            for (int rowNumber = 0; rowNumber < table.getRows().length; ++rowNumber) {
                TableBorderRow row = table.getRows()[rowNumber];
                INode rowNode = rowNodes.get(rowNumber);
                if (row.getNumberOfCellWithContent() == 0 && rowNode.getSemanticType() == null) {
                    rowNode.setSemanticType(SemanticType.TABLE_ROW);
                    rowNode.setBoundingBox(row.getBoundingBox());
                }
                row.setNode(rowNode);
            }
        }
    }

    private static void updateTreeWithRecognizedTableRows(TableBorder table, int depth) {
        for (TableBorderRow row : table.getRows()) {
            INode node = TableBorderConsumer.findParent(row.getNode(), depth);
            row.setNode(node);
            TableBorderConsumer.setType(node, SemanticType.TABLE_ROW, table.getId());
            TableBorderConsumer.updateTreeWithRecognizedTableRow(row, table, depth);
        }
    }

    private static void updateTreeWithRecognizedTableRowsGroups(TableBorder table, INode tableNode, Set<INode> rowNodes) {
        SortedSet<INode> nodes = TableBorderConsumer.findParents(rowNodes, tableNode.getDepth() + 1);
        Iterator iterator = nodes.iterator();
        if (nodes.size() < 4) {
            if (nodes.size() == 1) {
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_BODY, table.getId());
            } else if (nodes.size() == 2) {
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_HEADERS, table.getId());
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_BODY, table.getId());
            } else if (nodes.size() == 3) {
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_HEADERS, table.getId());
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_BODY, table.getId());
                TableBorderConsumer.setType((INode)iterator.next(), SemanticType.TABLE_FOOTER, table.getId());
            }
            ArrayList<INode> newRowNodes = new ArrayList<INode>();
            for (INode node : nodes) {
                newRowNodes.addAll(node.getChildren());
            }
            TableBorderConsumer.setTypesForEmptyRowNodes(table, newRowNodes);
        }
    }

    private static void updateTreeWithRecognizedTableRow(TableBorderRow row, TableBorder table, int depth) {
        INode rowNode = row.getNode();
        if (rowNode != null && rowNode.getChildren().size() == row.getNumberOfCells()) {
            int number = 0;
            for (int colNumber = 0; colNumber < row.cells.length; ++colNumber) {
                TableBorderCell cell = row.cells[colNumber];
                if (cell.rowNumber != row.rowNumber || cell.colNumber != colNumber) continue;
                INode cellNode = rowNode.getChildren().get(number);
                if (cell.getContent().isEmpty() && cellNode.getSemanticType() == null) {
                    cell.setNode(cellNode);
                    cellNode.setBoundingBox(cell.getBoundingBox());
                }
                ++number;
            }
        }
        List<INode> cells = TableBorderConsumer.findParents(Arrays.stream(row.cells).map(TableBorderCell::getNode).collect(Collectors.toList()), depth + 1);
        for (int colNumber = 0; colNumber < cells.size(); ++colNumber) {
            if (cells.get(colNumber) == null || row.cells[colNumber].rowNumber != row.rowNumber || row.cells[colNumber].colNumber != colNumber) continue;
            if (TableBorderConsumer.isHeaderCell(cells.get(colNumber), row.cells[colNumber], table)) {
                TableBorderConsumer.setType(cells.get(colNumber), SemanticType.TABLE_HEADER, table.getId());
                row.cells[colNumber].setSemanticType(SemanticType.TABLE_HEADER);
                continue;
            }
            TableBorderConsumer.setType(cells.get(colNumber), SemanticType.TABLE_CELL, table.getId());
            row.cells[colNumber].setSemanticType(SemanticType.TABLE_CELL);
        }
    }

    private static void setType(INode node, SemanticType type, Long id) {
        if (node != null) {
            if (TableUtils.isTableNode(node) && node.getRecognizedStructureId() != id) {
                node.setRecognizedStructureId(null);
            } else {
                node.setRecognizedStructureId(id);
                node.setSemanticType(type);
                node.setCorrectSemanticScore(1.0);
            }
        }
    }

    private INode getTableNode(TableBorder table) {
        HashSet<INode> rowNodes = new HashSet<INode>();
        for (TableBorderRow row : table.getRows()) {
            INode rowNode = this.getRowNode(row);
            if (rowNode == null) continue;
            row.setNode(rowNode);
            rowNodes.add(rowNode);
        }
        INode tableNode = TableBorderConsumer.findCommonParent(rowNodes);
        if (table.getNumberOfRowsWithContent() == 1 && tableNode != null) {
            INode parentTableNode;
            while (!tableNode.isRoot() && tableNode.getInitialSemanticType() != SemanticType.TABLE && TableBorderConsumer.getNumberOfChildrenWithContent(parentTableNode = tableNode.getParent()) == 1) {
                tableNode = parentTableNode;
            }
        }
        return tableNode;
    }

    private static int getNumberOfChildrenWithContent(INode node) {
        int numberOfChildrenWithContent = 0;
        for (INode child : node.getChildren()) {
            if (child.getSemanticType() == null) continue;
            ++numberOfChildrenWithContent;
        }
        return numberOfChildrenWithContent;
    }

    private INode getRowNode(TableBorderRow row) {
        HashSet<INode> cellNodes = new HashSet<INode>();
        for (int colNumber = 0; colNumber < row.cells.length; ++colNumber) {
            INode cellNode;
            TableBorderCell cell = row.cells[colNumber];
            if (cell.rowNumber != row.rowNumber || cell.colNumber != colNumber || (cellNode = this.getCellNode(cell)) == null) continue;
            cell.setNode(cellNode);
            cellNodes.add(cellNode);
        }
        INode rowNode = TableBorderConsumer.findCommonParent(cellNodes);
        if (rowNode != null && row.getNumberOfCellWithContent() == 1) {
            INode parentRowNode;
            while (!rowNode.isRoot() && rowNode.getInitialSemanticType() != SemanticType.TABLE_ROW && TableBorderConsumer.getNumberOfChildrenWithContent(parentRowNode = rowNode.getParent()) == 1 && parentRowNode.getInitialSemanticType() != SemanticType.TABLE && parentRowNode.getInitialSemanticType() != SemanticType.TABLE_BODY && parentRowNode.getInitialSemanticType() != SemanticType.TABLE_FOOTER && parentRowNode.getInitialSemanticType() != SemanticType.TABLE_HEADER) {
                rowNode = parentRowNode;
            }
        }
        return rowNode;
    }

    private static boolean isHeaderCell(INode cellNode, TableBorderCell cell, TableBorder table) {
        if (cellNode.getInitialSemanticType() != SemanticType.TABLE_HEADER) {
            return false;
        }
        if (cell.colNumber == 0 || cell.rowNumber == 0) {
            return true;
        }
        for (int rowNumber = cell.rowNumber; rowNumber < cell.rowNumber + cell.rowSpan; ++rowNumber) {
            if (table.getRows()[rowNumber].cells[cell.colNumber - 1].getSemanticType() != SemanticType.TABLE_HEADER) continue;
            return true;
        }
        for (int colNumber = cell.colNumber; colNumber < cell.colNumber + cell.colSpan; ++colNumber) {
            if (table.getRows()[cell.rowNumber - 1].cells[colNumber].getSemanticType() != SemanticType.TABLE_HEADER) continue;
            return true;
        }
        return false;
    }

    private INode getCellNode(TableBorderCell cell) {
        HashSet<INode> tableLeafNodes = new HashSet<INode>();
        for (TableToken token : cell.getContent()) {
            if (token.getNode() == null) continue;
            tableLeafNodes.add(token.getNode());
        }
        return TableBorderConsumer.findCommonParent(tableLeafNodes);
    }

    private static INode findParent(INode node, int depth) {
        if (node != null) {
            while (node.getDepth() > depth) {
                node = node.getParent();
            }
            if (node.getDepth() == depth) {
                return node;
            }
        }
        return null;
    }

    private static SortedSet<INode> findParents(Set<INode> nodes, int depth) {
        TreeSet<INode> parents = new TreeSet<INode>(Comparator.comparing(INode::getIndex));
        for (INode node : nodes) {
            if (node == null) continue;
            parents.add(TableBorderConsumer.findParent(node, depth));
        }
        return parents;
    }

    private static List<INode> findParents(List<INode> nodes, int depth) {
        return nodes.stream().map(node -> TableBorderConsumer.findParent(node, depth)).collect(Collectors.toList());
    }

    private static INode findCommonParent(Set<INode> nodes) {
        if (nodes.size() == 0) {
            return null;
        }
        if (nodes.size() == 1) {
            return nodes.iterator().next();
        }
        int minDepth = nodes.stream().map(INode::getDepth).min(Integer::compareTo).orElse(0);
        HashSet<INode> parents = new HashSet<INode>();
        Iterator<INode> iterator = nodes.iterator();
        while (iterator.hasNext()) {
            INode node;
            INode parent = node = iterator.next();
            while (parent.getDepth() > minDepth) {
                parent = parent.getParent();
            }
            parents.add(parent);
        }
        while (parents.size() > 1) {
            HashSet<INode> parentsSet = new HashSet<INode>();
            for (INode node : parents) {
                parentsSet.add(node.getParent());
            }
            parents = parentsSet;
        }
        return (INode)parents.iterator().next();
    }
}

