/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils;

import org.verapdf.wcag.algorithms.entities.content.TextChunk;

public class TextChunkUtils {
    public static final double WHITE_SPACE_FACTOR = 0.25;

    private TextChunkUtils() {
    }

    public static boolean isSpaceChunk(TextChunk chunk) {
        for (char symbol : chunk.getValue().toCharArray()) {
            if (Character.isSpaceChar(symbol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhiteSpaceChunk(TextChunk chunk) {
        for (char symbol : chunk.getValue().toCharArray()) {
            if (TextChunkUtils.isWhiteSpaceChar(symbol)) continue;
            return false;
        }
        return true;
    }

    public static boolean isWhiteSpaceChar(char symbol) {
        return Character.isWhitespace(symbol) || symbol == '\u00a0' || symbol == '\u2007' || symbol == '\u202f';
    }
}

