/*
 * Decompiled with CFR 0.152.
 */
package org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.verapdf.wcag.algorithms.entities.lists.ListInterval;
import org.verapdf.wcag.algorithms.semanticalgorithms.utils.listLabelsDetection.ListLabelsDetectionAlgorithm;

public abstract class LettersListLabelsDetectionAlgorithm
extends ListLabelsDetectionAlgorithm {
    @Override
    public boolean isListLabels(List<String> labels, int commonStartLength, int commonEndLength) {
        boolean isUpperCase;
        if (!labels.get(0).substring(commonStartLength, labels.get(0).length() - commonEndLength).matches(this.getRegex())) {
            return false;
        }
        int startLength = this.getNotRegexStartLength(labels.get(0), commonStartLength);
        int endLength = this.getNotRegexEndLength(labels.get(0), commonEndLength);
        String substring = labels.get(0).substring(startLength, labels.get(0).length() - endLength);
        if (substring.matches(this.getLowerCaseRegex())) {
            isUpperCase = false;
        } else if (substring.matches(this.getUpperCaseRegex())) {
            isUpperCase = true;
        } else {
            return false;
        }
        Integer number = this.getNumberFromString(substring.toUpperCase());
        if (number == null) {
            return false;
        }
        if (!substring.toUpperCase().equals(this.getStringFromNumber(number))) {
            return false;
        }
        for (int i = 1; i < labels.size(); ++i) {
            substring = labels.get(i).substring(startLength, labels.get(i).length() - endLength);
            if (!(substring.matches(this.getLowerCaseRegex()) && !isUpperCase || substring.matches(this.getUpperCaseRegex()) && isUpperCase)) {
                return false;
            }
            Integer nextNumber = this.getNumberFromString(substring.toUpperCase());
            if (nextNumber == null) {
                return false;
            }
            if (substring.toUpperCase().equals(this.getStringFromNumber(nextNumber)) && nextNumber == (number = Integer.valueOf(number + 1))) continue;
            return false;
        }
        return true;
    }

    @Override
    public Set<ListInterval> getItemsIntervals(List<String> items) {
        HashSet<ListInterval> listIntervals = new HashSet<ListInterval>();
        int index = 0;
        Integer number = null;
        int start = 0;
        String prefix = null;
        boolean isUpperCase = false;
        for (int i = 0; i < items.size(); ++i) {
            if (number != null) {
                Integer n = number;
                Integer n2 = number = Integer.valueOf(number + 1);
                String s = this.getStringFromNumber(number);
                if (items.get(i).toUpperCase().startsWith(s, start) && items.get(i).startsWith(prefix) && !this.isCharMatchRegex(items.get(i), start + s.length()) && (items.get(i).substring(start, start + s.length()).matches(this.getLowerCaseRegex()) && !isUpperCase || items.get(i).substring(start, start + s.length()).matches(this.getUpperCaseRegex()) && isUpperCase)) continue;
                if (i > index + 1) {
                    listIntervals.add(new ListInterval(index, --i));
                }
                --i;
                number = null;
                continue;
            }
            if (i == items.size() - 1) continue;
            int commonLength = LettersListLabelsDetectionAlgorithm.getCommonStartLength(items.get(i), items.get(i + 1));
            start = this.getNotRegexStartLength(items.get(i), commonLength);
            prefix = items.get(i).substring(0, start);
            String substring = items.get(i).substring(start);
            if ((substring = substring.substring(0, this.getRegexStartLength(substring))).matches(this.getLowerCaseRegex())) {
                isUpperCase = false;
            } else {
                if (!substring.matches(this.getUpperCaseRegex())) continue;
                isUpperCase = true;
            }
            number = this.getNumberFromString(substring.toUpperCase());
            if (number == null) continue;
            if (!substring.toUpperCase().startsWith(this.getStringFromNumber(number))) {
                number = null;
                continue;
            }
            index = i;
        }
        if (number != null && items.size() > index + 1) {
            listIntervals.add(new ListInterval(index, items.size() - 1));
        }
        return listIntervals;
    }

    protected abstract String getLowerCaseRegex();

    protected abstract String getUpperCaseRegex();

    protected boolean isCharMatchRegex(String s, int index) {
        return LettersListLabelsDetectionAlgorithm.isCharMatchRegex(s, index, this.getRegex());
    }

    private static boolean isCharMatchRegex(String s, int index, String regex) {
        if (s.length() <= index) {
            return false;
        }
        return s.substring(index, index + 1).matches(regex);
    }
}

